/*
 * Decompiled with CFR 0.152.
 */
package com.activeandroid;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.activeandroid.Cache;
import com.activeandroid.Configuration;
import com.activeandroid.util.Log;

public final class ActiveAndroid {
    public static void initialize(Context context) {
        ActiveAndroid.initialize(new Configuration.Builder(context).create());
    }

    public static void initialize(Configuration configuration) {
        ActiveAndroid.initialize(configuration, false);
    }

    public static void initialize(Context context, boolean loggingEnabled) {
        ActiveAndroid.initialize(new Configuration.Builder(context).create(), loggingEnabled);
    }

    public static void initialize(Configuration configuration, boolean loggingEnabled) {
        ActiveAndroid.setLoggingEnabled(loggingEnabled);
        Cache.initialize(configuration);
    }

    public static void clearCache() {
        Cache.clear();
    }

    public static void dispose() {
        Cache.dispose();
    }

    public static void setLoggingEnabled(boolean enabled) {
        Log.setEnabled(enabled);
    }

    public static SQLiteDatabase getDatabase() {
        return Cache.openDatabase();
    }

    public static void beginTransaction() {
        Cache.openDatabase().beginTransactionNonExclusive();
    }

    public static void endTransaction() {
        Cache.openDatabase().endTransaction();
    }

    public static void setTransactionSuccessful() {
        Cache.openDatabase().setTransactionSuccessful();
    }

    public static boolean inTransaction() {
        return Cache.openDatabase().inTransaction();
    }

    public static void execSQL(String sql) {
        Cache.openDatabase().execSQL(sql);
    }

    public static void execSQL(String sql, Object[] bindArgs) {
        Cache.openDatabase().execSQL(sql, bindArgs);
    }
}

