/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import com.joyhonest.wifination.MyMediaMuxer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoMediaCoder {
    long pts;
    public long pts_;
    int fps;
    private MediaCodec mMediaCodec = null;
    private static final String VCODEC = "video/avc";
    private static final String TAG = "MediaCoder";
    private boolean bGetPPS = false;
    public long nCountFrame = 0L;
    int ddd = 0;

    private MediaFormat F_GetMediaFormat(int width, int height, int bitrate, int fps, int color) {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
            this.pts = 0L;
            this.pts_ = 0L;
            this.nCountFrame = 0L;
        }
        this.bGetPPS = false;
        this.pts = 0L;
        this.pts_ = 0L;
        this.nCountFrame = 0L;
        this.fps = fps;
        boolean bOK = true;
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)VCODEC);
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            e.printStackTrace();
            bOK = false;
        }
        if (!bOK) {
            this.mMediaCodec = null;
            return null;
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)VCODEC, (int)width, (int)height);
        mediaFormat.setInteger("width", width);
        mediaFormat.setInteger("height", height);
        mediaFormat.setInteger("bitrate", bitrate);
        mediaFormat.setInteger("i-frame-interval", 1);
        mediaFormat.setInteger("frame-rate", fps);
        mediaFormat.setInteger("color-format", color);
        if (Build.VERSION.SDK_INT >= 21) {
            mediaFormat.setInteger("bitrate-mode", 1);
            mediaFormat.setInteger("profile", 1);
            mediaFormat.setInteger("level", 1);
            mediaFormat.setInteger("capture-rate", fps);
        }
        try {
            this.mMediaCodec.configure(mediaFormat, null, null, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            mediaFormat = null;
        }
        return mediaFormat;
    }

    public int initMediaCodec(int width, int height, int bitrate, int fps) {
        int nColor = 21;
        if (this.F_GetMediaFormat(width, height, bitrate, fps, nColor) == null && this.F_GetMediaFormat(width, height, bitrate, fps, nColor = 19) == null) {
            nColor = 0;
        }
        if (nColor != 0) {
            this.mMediaCodec.start();
        } else {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        return nColor;
    }

    public void F_CloseEncoder() {
        if (this.mMediaCodec == null) {
            return;
        }
        this.mMediaCodec.stop();
        this.mMediaCodec.release();
        this.mMediaCodec = null;
        this.bGetPPS = false;
        this.nCountFrame = 0L;
        Log.e((String)TAG, (String)"Close MediaCodec!!!---");
    }

    public long getRecordTime() {
        if (this.fps > 0) {
            float df = 1000.0f / (float)this.fps;
            return (long)((float)this.nCountFrame * df);
        }
        return 0L;
    }

    private int getColorFormat() {
        MediaCodecInfo mediaCodecInfo = this.chooseVideoEncoder(null);
        if (mediaCodecInfo == null) {
            return 0;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(VCODEC);
        for (int i = 0; i < codecCapabilities.colorFormats.length; ++i) {
            int format = codecCapabilities.colorFormats[i];
            if (format != 19) {
                if (format != 21) continue;
            }
            return format;
        }
        return 0;
    }

    public void offerEncoder(byte[] data, int nLen) {
        if (this.mMediaCodec == null) {
            return;
        }
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        ByteBuffer[] outputBuffers = this.mMediaCodec.getOutputBuffers();
        int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(5000L);
        if (inputBufferIndex >= 0) {
            this.pts_ = this.pts * (long)(1000000 / this.fps);
            ++this.pts;
            ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
            inputBuffer.clear();
            inputBuffer.put(data);
            this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, data.length, this.pts_, 0);
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int outputBufferIndex = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 2000L);
            if (outputBufferIndex == -2) {
                MediaFormat newFormat = this.mMediaCodec.getOutputFormat();
                MyMediaMuxer.AddVideoTrack(newFormat);
            }
            if (outputBufferIndex >= 0) {
                ByteBuffer outputBuffer = outputBuffers[outputBufferIndex];
                byte[] outData = new byte[bufferInfo.size];
                outputBuffer.get(outData);
                boolean bKeyframe = false;
                if (bufferInfo.flags == 2) {
                    if (!this.bGetPPS) {
                        this.bGetPPS = true;
                    }
                } else {
                    if (bufferInfo.flags == 1) {
                        bKeyframe = true;
                    }
                    ++this.nCountFrame;
                    MyMediaMuxer.WritSample(outData, bKeyframe, true, this.pts_);
                }
                this.mMediaCodec.releaseOutputBuffer(outputBufferIndex, false);
            }
        }
    }

    private MediaCodecInfo chooseVideoEncoder(String name) {
        int nbCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < nbCodecs; ++i) {
            MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
            if (!mci.isEncoder()) continue;
            String[] types = mci.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(VCODEC)) continue;
                if (name == null) {
                    return mci;
                }
                if (!mci.getName().contains(name)) continue;
                return mci;
            }
        }
        return null;
    }
}

