/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.joyhonest.wifination.Classifier;
import com.joyhonest.wifination.JH_ObjectDetectionAPIModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.simple.eventbus.EventBus;

public class ObjectDetector {
    private static Context AppContext = null;
    public static int nWidth = 300;
    public static int nHeight = 300;
    private boolean bBusy = false;
    private boolean bStar = false;
    private Classifier detector;
    public static float MINIMUM_CONFIDENCE_TF_OD_API = 0.25f;
    private static final String TF_OD_API_MODEL_FILE = "file:///android_asset/frozen_inference_graph.pb";
    private static final String TF_OD_API_LABELS_FILE = "file:///android_asset/mydata.txt";
    private Matrix frameToCropTransform;
    private Matrix cropToFrameTransform;
    private Bitmap croppedBitmap = Bitmap.createBitmap((int)nWidth, (int)nHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    private Canvas canvas = new Canvas(this.croppedBitmap);
    private Handler handler;
    private HandlerThread handlerThread;
    int nFindD2 = 0;
    int nNoFind = 0;

    public boolean isbBusy() {
        return this.bBusy;
    }

    public void F_SetWidth_Height(int nW, int nH) {
        nWidth = nW;
        nHeight = nH;
    }

    private ObjectDetector() {
    }

    public void SetAppCentext(Context context) {
        if (AppContext == null) {
            AppContext = context;
        }
        if (AppContext != null && this.detector == null) {
            try {
                this.detector = JH_ObjectDetectionAPIModel.create(AppContext.getAssets(), TF_OD_API_MODEL_FILE, TF_OD_API_LABELS_FILE, nWidth, nHeight);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ObjectDetector getInstance() {
        return SingleTonHoulder.singleTonInstance;
    }

    public void F_Start(boolean _bStart) {
        if (this.bStar && !_bStart) {
            if (this.handler != null) {
                this.handler.removeCallbacksAndMessages(null);
                this.handler = null;
            }
            if (this.handlerThread != null) {
                this.handlerThread.quit();
            }
            this.bStar = _bStart;
            return;
        }
        if (!this.bStar && _bStart) {
            this.handlerThread = new HandlerThread("_Obj__jhabc_");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
            this.bStar = _bStart;
        }
    }

    public int GetNumber(Bitmap bmp) {
        if (bmp == null) {
            return -1;
        }
        if (!this.bStar) {
            return -2;
        }
        if (this.bBusy) {
            return -3;
        }
        this.bBusy = true;
        this.croppedBitmap = bmp;
        this.runInBackground(new Runnable(){

            @Override
            public void run() {
                ObjectDetector.this.progressImage();
            }
        });
        return 0;
    }

    private void progressImage() {
        List<Classifier.Recognition> results = this.detector.recognizeImage(this.croppedBitmap);
        float minimumConfidence = MINIMUM_CONFIDENCE_TF_OD_API;
        boolean bFind = false;
        String id_ = "";
        boolean bfirset = true;
        boolean nMax = false;
        float nre = 0.0f;
        for (Classifier.Recognition result : results) {
            RectF location = result.getLocation();
            if (location == null || !((nre = result.getConfidence().floatValue()) >= minimumConfidence)) continue;
            id_ = result.getTitle();
            bFind = true;
            if (!id_.equals("D2") && !id_.equals("D3")) continue;
            if (this.nFindD2 < 5) {
                ++this.nFindD2;
            }
            if (this.nFindD2 != 1) continue;
            this.nNoFind = 0;
            Log.e((String)"GGG", (String)(id_ + " confidence  D2"));
            EventBus.getDefault().post((Object)"D2", "GetGueset");
            break;
        }
        if (!bFind) {
            if (this.nNoFind < 5) {
                ++this.nNoFind;
            }
            if (this.nNoFind == 2) {
                this.nFindD2 = 0;
                Log.e((String)"GGG", (String)(id_ + " confidence-------"));
                EventBus.getDefault().post((Object)"", "GetGueset");
            }
        }
        this.bBusy = false;
    }

    private synchronized void runInBackground(Runnable r) {
        if (this.handler != null) {
            this.handler.post(r);
        }
    }

    public String getNormalSDCardPath() {
        return Environment.getExternalStorageDirectory().getPath();
    }

    public void saveBitmap2file(Bitmap bmp, Context context) {
        String fileName = this.getNormalSDCardPath() + "/abc.jpg";
        File filePic = new File(fileName);
        try {
            if (!filePic.exists()) {
                filePic.getParentFile().mkdirs();
                filePic.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(filePic);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class SingleTonHoulder {
        private static final ObjectDetector singleTonInstance = new ObjectDetector();
    }
}

