/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import com.joyhonest.wifination.wifination;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoMediaCoder {
    long pts;
    int fps;
    private MediaCodec mMediaCodec = null;
    private static final String VCODEC = "video/avc";
    private static final String TAG = "MediaCoder";
    private boolean bGetPPS = false;
    int ddd = 0;

    private MediaFormat F_GetMediaFormat(int width, int height, int bitrate, int fps, int color) {
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)VCODEC, (int)width, (int)height);
        mediaFormat.setInteger("width", width);
        mediaFormat.setInteger("height", height);
        mediaFormat.setInteger("bitrate", bitrate);
        mediaFormat.setInteger("frame-rate", fps);
        mediaFormat.setInteger("color-format", color);
        mediaFormat.setInteger("i-frame-interval", 2);
        try {
            this.mMediaCodec.configure(mediaFormat, null, null, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            mediaFormat = null;
        }
        return mediaFormat;
    }

    public int initMediaCodec(int width, int height, int bitrate, int fps) {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mMediaCodec.release();
            this.mMediaCodec = null;
            this.pts = 0L;
        }
        this.bGetPPS = false;
        this.pts = 0L;
        this.fps = fps;
        boolean bOK = true;
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)VCODEC);
        }
        catch (IOException e) {
            e.printStackTrace();
            bOK = false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            bOK = false;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            bOK = false;
        }
        if (!bOK) {
            this.mMediaCodec = null;
            return 524287;
        }
        int nColor = 21;
        if (this.F_GetMediaFormat(width, height, bitrate, fps, nColor) == null) {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
                this.pts = 0L;
            }
            this.bGetPPS = false;
            this.pts = 0L;
            this.fps = fps;
            bOK = true;
            try {
                this.mMediaCodec = MediaCodec.createEncoderByType((String)VCODEC);
            }
            catch (IOException e) {
                e.printStackTrace();
                bOK = false;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                bOK = false;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                bOK = false;
            }
            if (!bOK) {
                this.mMediaCodec = null;
                return 524287;
            }
            nColor = 19;
            if (this.F_GetMediaFormat(width, height, bitrate, fps, nColor) == null) {
                nColor = 0;
            }
        }
        if (nColor != 0) {
            this.mMediaCodec.start();
        } else {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        return nColor;
    }

    public void F_CloseEncoder() {
        if (this.mMediaCodec == null) {
            return;
        }
        this.mMediaCodec.stop();
        this.mMediaCodec.release();
        this.mMediaCodec = null;
        this.bGetPPS = false;
    }

    public void offerEncoder(byte[] data, int nLen) {
        if (this.mMediaCodec == null) {
            return;
        }
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        ByteBuffer[] outputBuffers = this.mMediaCodec.getOutputBuffers();
        int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(5000L);
        if (inputBufferIndex >= 0) {
            long ppp = this.pts * (long)(1000000 / this.fps);
            ++this.pts;
            ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
            inputBuffer.clear();
            inputBuffer.put(data);
            this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, data.length, ppp, 0);
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int outputBufferIndex = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 2000L);
            if (outputBufferIndex >= 0) {
                ByteBuffer outputBuffer = outputBuffers[outputBufferIndex];
                byte[] outData = new byte[bufferInfo.size];
                outputBuffer.get(outData);
                boolean bKeyframe = false;
                if (bufferInfo.flags == 2) {
                    if (!this.bGetPPS) {
                        this.bGetPPS = true;
                        wifination.naSave2FrameMp4(outData, bufferInfo.size, 0, bKeyframe);
                    }
                } else if (bufferInfo.flags == 1) {
                    bKeyframe = true;
                    wifination.naSave2FrameMp4(outData, bufferInfo.size, 1, bKeyframe);
                } else {
                    wifination.naSave2FrameMp4(outData, bufferInfo.size, 1, bKeyframe);
                }
                this.mMediaCodec.releaseOutputBuffer(outputBufferIndex, false);
            }
        }
    }

    private MediaCodecInfo chooseVideoEncoder(String name, MediaCodecInfo def) {
        int nbCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < nbCodecs; ++i) {
            MediaCodecInfo mci = MediaCodecList.getCodecInfoAt((int)i);
            if (!mci.isEncoder()) continue;
            String[] types = mci.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(VCODEC)) continue;
                if (name == null) {
                    return mci;
                }
                if (!mci.getName().contains(name)) continue;
                return mci;
            }
        }
        return def;
    }

    private int chooseVideoEncoder() {
        int i;
        MediaCodecInfo vmci = this.chooseVideoEncoder(null, null);
        int matchedColorFormat = 0;
        MediaCodecInfo.CodecCapabilities cc = vmci.getCapabilitiesForType(VCODEC);
        for (i = 0; i < cc.colorFormats.length; ++i) {
            int cf = cc.colorFormats[i];
            Log.i((String)TAG, (String)String.format("vencoder %s supports color fomart 0x%x(%d)", vmci.getName(), cf, cf));
            if (cf < 19) continue;
            if (cf > 21 || cf <= matchedColorFormat) continue;
            matchedColorFormat = cf;
        }
        for (i = 0; i < cc.profileLevels.length; ++i) {
            MediaCodecInfo.CodecProfileLevel pl = cc.profileLevels[i];
            Log.i((String)TAG, (String)String.format("vencoder %s support profile %d, level %d", vmci.getName(), pl.profile, pl.level));
        }
        Log.i((String)TAG, (String)String.format("vencoder %s choose color format 0x%x(%d)", vmci.getName(), matchedColorFormat, matchedColorFormat));
        return matchedColorFormat;
    }
}

