/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.wifination;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.RectF;
import com.joyhonest.wifination.Classifier;
import com.joyhonest.wifination.Logger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Vector;
import org.tensorflow.Graph;
import org.tensorflow.Operation;
import org.tensorflow.contrib.android.TensorFlowInferenceInterface;

public class JH_ObjectDetectionAPIModel
implements Classifier {
    private static final Logger LOGGER = new Logger();
    private static final int MAX_RESULTS = 100;
    private String inputName;
    private int inputSize;
    private Vector<String> labels = new Vector();
    private int[] intValues;
    private byte[] byteValues;
    private float[] outputLocations;
    private float[] outputScores;
    private float[] outputClasses;
    private float[] outputNumDetections;
    private String[] outputNames;
    private boolean logStats = false;
    private TensorFlowInferenceInterface inferenceInterface;

    public static Classifier create(AssetManager assetManager, String modelFilename, String labelFilename, int inputSize) throws IOException {
        String line;
        JH_ObjectDetectionAPIModel d = new JH_ObjectDetectionAPIModel();
        InputStream labelsInput = null;
        String actualFilename = labelFilename.split("file:///android_asset/")[1];
        if (actualFilename != null && assetManager != null) {
            labelsInput = assetManager.open(actualFilename);
        }
        if (labelsInput == null) {
            labelsInput = new FileInputStream(labelFilename);
        }
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader(labelsInput));
        while ((line = br.readLine()) != null) {
            LOGGER.w(line, new Object[0]);
            d.labels.add(line);
        }
        br.close();
        d.inferenceInterface = new TensorFlowInferenceInterface(assetManager, modelFilename);
        Graph g = d.inferenceInterface.graph();
        d.inputName = "image_tensor";
        Operation inputOp = g.operation(d.inputName);
        if (inputOp == null) {
            throw new RuntimeException("Failed to find input Node '" + d.inputName + "'");
        }
        d.inputSize = inputSize;
        Operation outputOp1 = g.operation("detection_scores");
        if (outputOp1 == null) {
            throw new RuntimeException("Failed to find output Node 'detection_scores'");
        }
        Operation outputOp2 = g.operation("detection_boxes");
        if (outputOp2 == null) {
            throw new RuntimeException("Failed to find output Node 'detection_boxes'");
        }
        Operation outputOp3 = g.operation("detection_classes");
        if (outputOp3 == null) {
            throw new RuntimeException("Failed to find output Node 'detection_classes'");
        }
        d.outputNames = new String[]{"detection_boxes", "detection_scores", "detection_classes", "num_detections"};
        d.intValues = new int[d.inputSize * d.inputSize];
        d.byteValues = new byte[d.inputSize * d.inputSize * 3];
        d.outputScores = new float[100];
        d.outputLocations = new float[400];
        d.outputClasses = new float[100];
        d.outputNumDetections = new float[1];
        return d;
    }

    private JH_ObjectDetectionAPIModel() {
    }

    @Override
    public List<Classifier.Recognition> recognizeImage(Bitmap bitmap) {
        bitmap.getPixels(this.intValues, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        for (int i = 0; i < this.intValues.length; ++i) {
            this.byteValues[i * 3 + 2] = (byte)(this.intValues[i] & 0xFF);
            this.byteValues[i * 3 + 1] = (byte)(this.intValues[i] >> 8 & 0xFF);
            this.byteValues[i * 3 + 0] = (byte)(this.intValues[i] >> 16 & 0xFF);
        }
        this.inferenceInterface.feed(this.inputName, this.byteValues, new long[]{1L, this.inputSize, this.inputSize, 3L});
        this.inferenceInterface.run(this.outputNames, this.logStats);
        this.outputLocations = new float[400];
        this.outputScores = new float[100];
        this.outputClasses = new float[100];
        this.outputNumDetections = new float[1];
        this.inferenceInterface.fetch(this.outputNames[0], this.outputLocations);
        this.inferenceInterface.fetch(this.outputNames[1], this.outputScores);
        this.inferenceInterface.fetch(this.outputNames[2], this.outputClasses);
        this.inferenceInterface.fetch(this.outputNames[3], this.outputNumDetections);
        PriorityQueue<Classifier.Recognition> pq = new PriorityQueue<Classifier.Recognition>(1, new Comparator<Classifier.Recognition>(){

            @Override
            public int compare(Classifier.Recognition lhs, Classifier.Recognition rhs) {
                return Float.compare(rhs.getConfidence().floatValue(), lhs.getConfidence().floatValue());
            }
        });
        for (int i = 0; i < this.outputScores.length; ++i) {
            RectF detection = new RectF(this.outputLocations[4 * i + 1] * (float)this.inputSize, this.outputLocations[4 * i] * (float)this.inputSize, this.outputLocations[4 * i + 3] * (float)this.inputSize, this.outputLocations[4 * i + 2] * (float)this.inputSize);
            pq.add(new Classifier.Recognition("" + i, this.labels.get((int)this.outputClasses[i]), Float.valueOf(this.outputScores[i]), detection));
        }
        ArrayList<Classifier.Recognition> recognitions = new ArrayList<Classifier.Recognition>();
        for (int i = 0; i < Math.min(pq.size(), 100); ++i) {
            recognitions.add(pq.poll());
        }
        return recognitions;
    }

    @Override
    public void enableStatLogging(boolean logStats) {
        this.logStats = logStats;
    }

    @Override
    public String getStatString() {
        return this.inferenceInterface.getStatString();
    }

    @Override
    public void close() {
        this.inferenceInterface.close();
    }
}

