/*
 * Decompiled with CFR 0.152.
 */
package com.joyhonest.jh_ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;

public class MyControl_A
extends RelativeLayout {
    private RockeView rock1;
    private RockeView rock2;
    private int nWW;
    private int nCWW;
    private int nRectW = 1;
    private int nRectH = 1;
    private Rect rectleft;
    private Rect rectright;
    private Bitmap bmp1;
    private Bitmap bmp2;

    public void F_SetBackFly(Bitmap bmp1, Bitmap bmp2) {
        this.bmp1 = bmp1;
        this.bmp2 = bmp2;
    }

    public MyControl_A(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MyControl_A(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public MyControl_A(Context context) {
        super(context);
        this.init();
    }

    public int F_GetX1() {
        return this.rock1.F_GetX();
    }

    public int F_GetY1() {
        return this.rock1.F_GetY();
    }

    public int F_GetX2() {
        return this.rock2.F_GetX();
    }

    public int F_GetY2() {
        return this.rock2.F_GetY();
    }

    public void F_SetBackGround(int backbmo, int cirbmp) {
        this.rock1.F_SetBackBmp_CirBmpId(backbmo, cirbmp);
        this.rock2.F_SetBackBmp_CirBmpId(backbmo, cirbmp);
    }

    public void F_SetBackGroundbyColor(int backbmo, int cirbmp) {
        this.rock1.F_SetBack_Cir_Color(backbmo, cirbmp);
        this.rock2.F_SetBack_Cir_Color(backbmo, cirbmp);
    }

    public void F_SetW_W(int W, int W1) {
        this.nWW = W;
        this.nCWW = W1;
        this.F_SetSize();
    }

    private void init() {
        this.rectleft = new Rect();
        this.rectright = new Rect();
        this.rock1 = new RockeView(this.getContext());
        this.rock2 = new RockeView(this.getContext());
        this.addView(this.rock1);
        this.addView(this.rock2);
        this.nWW = -1;
        this.nCWW = -1;
        this.rock1.F_SetWidth_Height(this.nWW, this.nCWW);
        this.rock2.F_SetWidth_Height(this.nWW, this.nCWW);
        this.setBackgroundColor(0xFFFFFF);
    }

    private void F_SetSize() {
        if (this.nCWW > 0 && this.nWW > 0) {
            this.rock1.F_SetWidth_Height(this.nWW, this.nCWW);
            this.rock2.F_SetWidth_Height(this.nWW, this.nCWW);
        } else {
            int ws = this.nRectW / 2;
            int hs = this.nRectH;
            int ww = Math.min(ws, hs);
            ww = ww * 2 / 3;
            int cw = ww / 6;
            this.rock1.F_SetWidth_Height(ww, cw);
            this.rock2.F_SetWidth_Height(ww, cw);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.nRectW = w;
        this.nRectH = h;
        this.rectleft.top = 0;
        this.rectleft.left = 0;
        this.rectleft.bottom = this.nRectH;
        this.rectleft.right = this.nRectW / 2;
        this.rectright.top = 0;
        this.rectright.left = this.nRectW / 2;
        this.rectright.bottom = this.nRectH;
        this.rectright.right = this.nRectW;
        this.F_SetSize();
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        int action_code = action & 0xFF;
        int pointIndex = action >> 8;
        int x = (int)event.getX(pointIndex);
        int y = (int)event.getY(pointIndex);
        int ida = event.getPointerId(pointIndex);
        switch (action_code) {
            case 0: {
                if (this.rectleft.contains(x, y)) {
                    this.rock1.nTouchID = ida;
                    this.rock1.F_SetCenter(x, y);
                    break;
                }
                if (!this.rectright.contains(x, y)) break;
                this.rock2.nTouchID = ida;
                this.rock2.F_SetCenter(x, y);
                break;
            }
            case 5: {
                if (this.rectleft.contains(x, y)) {
                    if (this.rock1.nTouchID >= 0) break;
                    this.rock1.nTouchID = ida;
                    this.rock1.F_SetCenter(x, y);
                    break;
                }
                if (!this.rectright.contains(x, y) || this.rock2.nTouchID >= 0) break;
                this.rock2.nTouchID = ida;
                this.rock2.F_SetCenter(x, y);
                break;
            }
            case 2: {
                int index1 = event.findPointerIndex(this.rock1.nTouchID);
                int index2 = event.findPointerIndex(this.rock2.nTouchID);
                if (index1 != -1) {
                    x = (int)event.getX(index1);
                    y = (int)event.getY(index1);
                    this.rock1.F_Update(x, y);
                }
                if (index2 == -1) break;
                x = (int)event.getX(index2);
                y = (int)event.getY(index2);
                this.rock2.F_Update(x, y);
                break;
            }
            case 6: {
                if (this.rock1.nTouchID == ida) {
                    this.rock1.nTouchID = -1;
                    this.rock1.F_SetCenter(-1, -1);
                }
                if (this.rock2.nTouchID != ida) break;
                this.rock2.nTouchID = -1;
                this.rock2.F_SetCenter(-1, -1);
                break;
            }
            case 1: 
            case 3: {
                this.rock1.nTouchID = -1;
                this.rock2.nTouchID = -1;
                this.rock1.F_SetCenter(-1, -1);
                this.rock2.F_SetCenter(-1, -1);
            }
        }
        return true;
    }

    private class RockeView
    extends View {
        public int nTouchID;
        private Point mCenter;
        private Bitmap mBackBmp;
        private Bitmap mCirBmp;
        private int mBackColor;
        private int ietmCirColor;
        private int mWidth;
        private int mWidth_cir;
        public int XX;
        public int YY;
        private int nPointX;
        private int nPointY;
        private int nCirX;
        private int nCirY;
        private boolean bDisplay;

        public int F_GetX() {
            int w = this.mWidth / 2 - this.mWidth_cir / 2;
            if (this.mCenter.x == this.nCirX) {
                return 128;
            }
            float nb = this.nCirX - (this.mCenter.x - w);
            int re = (int)(255.0f * (nb / (float)(w * 2)));
            if (re < 0) {
                re = 0;
            }
            if (re > 255) {
                re = 255;
            }
            return re;
        }

        public int F_GetY() {
            int w = this.mWidth / 2 - this.mWidth_cir / 2;
            if (this.mCenter.y == this.nCirY) {
                return 128;
            }
            float nb = this.nCirY - (this.mCenter.y - w);
            int re = (int)(255.0f * (nb / (float)(w * 2)));
            if ((re = 255 - re) < 0) {
                re = 0;
            }
            if (re > 255) {
                re = 255;
            }
            return re;
        }

        public RockeView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.nTouchID = -1;
            this.mBackBmp = null;
            this.mCirBmp = null;
            this.mBackColor = -3355444;
            this.ietmCirColor = -1;
            this.XX = 128;
            this.YY = 128;
            this.nPointX = -1;
            this.nPointY = -1;
            this.nCirX = -1;
            this.nCirY = -1;
            this.bDisplay = true;
            this.init();
        }

        public RockeView(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.nTouchID = -1;
            this.mBackBmp = null;
            this.mCirBmp = null;
            this.mBackColor = -3355444;
            this.ietmCirColor = -1;
            this.XX = 128;
            this.YY = 128;
            this.nPointX = -1;
            this.nPointY = -1;
            this.nCirX = -1;
            this.nCirY = -1;
            this.bDisplay = true;
            this.init();
        }

        public RockeView(Context context) {
            super(context);
            this.nTouchID = -1;
            this.mBackBmp = null;
            this.mCirBmp = null;
            this.mBackColor = -3355444;
            this.ietmCirColor = -1;
            this.XX = 128;
            this.YY = 128;
            this.nPointX = -1;
            this.nPointY = -1;
            this.nCirX = -1;
            this.nCirY = -1;
            this.bDisplay = true;
            this.init();
        }

        private void init() {
            this.XX = 128;
            this.YY = 128;
            this.mWidth = -1;
            this.nPointX = -1;
            this.nPointY = -1;
            this.mCenter = new Point(-1, -1);
        }

        public void F_SetBackBmp_CirBmpId(int background, int cirbmp) {
            this.mBackBmp = background < 0 ? null : BitmapFactory.decodeResource((Resources)this.getResources(), (int)background);
            this.mCirBmp = cirbmp < 0 ? null : BitmapFactory.decodeResource((Resources)this.getResources(), (int)cirbmp);
            this.invalidate();
        }

        public void F_SetBack_Cir_Color(int backgroundcolor, int cirbmpcolor) {
            this.mBackColor = backgroundcolor;
            this.ietmCirColor = cirbmpcolor;
            this.invalidate();
        }

        public void F_SetWidth_Height(int w, int wcir) {
            this.mWidth = w;
            this.mWidth_cir = wcir;
            this.invalidate();
        }

        public void F_Update(int x, int y) {
            this.nPointX = x;
            this.nPointY = y;
            if (x < 0 || y < 0) {
                this.nPointX = this.mCenter.x;
                this.nPointY = this.mCenter.y;
                this.bDisplay = false;
            } else {
                this.bDisplay = true;
            }
            int centx = this.mCenter.x;
            int centy = this.mCenter.y;
            int dx = this.nPointX - centx;
            int dy = this.nPointY - centy;
            int da = dx * dx + dy * dy;
            da = (int)Math.sqrt(da);
            int r = this.mWidth / 2 - this.mWidth_cir / 2;
            if (da < r) {
                this.nCirX = this.nPointX;
                this.nCirY = this.nPointY;
            } else {
                int cirx = dx * r / da;
                int ciry = dy * r / da;
                this.nCirX = cirx += centx;
                this.nCirY = ciry += centy;
            }
            this.invalidate();
        }

        public void F_SetCenter(int x, int y) {
            this.mCenter.x = x;
            this.mCenter.y = y;
            this.nCirX = x;
            this.nCirY = y;
            this.invalidate();
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
        }

        protected void onDraw(Canvas canvas) {
            Rect dstRect;
            super.onDraw(canvas);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            if (this.mCenter.x < 0 || this.mCenter.y < 0 || this.mWidth < 0 || this.nCirX < 0 || this.nCirY < 0 || !this.bDisplay) {
                return;
            }
            if (this.mBackBmp != null) {
                dstRect = new Rect(this.mCenter.x - this.mWidth / 2, this.mCenter.y - this.mWidth / 2, this.mCenter.x + this.mWidth / 2, this.mCenter.y + this.mWidth / 2);
                canvas.drawBitmap(this.mBackBmp, null, dstRect, null);
            } else {
                paint.setColor(this.mBackColor);
                canvas.drawCircle((float)this.mCenter.x, (float)this.mCenter.y, (float)(this.mWidth / 2), paint);
            }
            if (this.mCirBmp != null) {
                dstRect = new Rect(this.nCirX - this.mWidth_cir / 2, this.nCirY - this.mWidth_cir / 2, this.nCirX + this.mWidth_cir / 2, this.nCirY + this.mWidth_cir / 2);
                canvas.drawBitmap(this.mCirBmp, null, dstRect, null);
            } else {
                paint.setColor(this.ietmCirColor);
                canvas.drawCircle((float)this.nCirX, (float)this.nCirY, (float)(this.mWidth_cir / 2), paint);
            }
        }
    }
}

