/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.descriptor.VideoPageDescriptor;
import com.cube.storm.ui.model.list.VideoListItem;
import com.cube.storm.ui.model.property.LinkProperty;
import com.cube.storm.ui.model.property.VideoProperty;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;
import java.util.ArrayList;
import java.util.Iterator;

public class VideoListItemHolder
extends Holder<VideoListItem>
implements ViewClickable<VideoListItem> {
    protected ImageView image;
    protected ProgressBar progress;
    protected LinearLayout embeddedLinksContainer;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.video_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image);
        this.progress = (ProgressBar)view.findViewById(R.id.progress);
        this.embeddedLinksContainer = (LinearLayout)view.findViewById(R.id.embedded_links_container);
        return view;
    }

    @Override
    public void populateView(final VideoListItem model) {
        if (model.getImage() != null) {
            UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getSrc(), this.image, (ImageLoadingListener)new SimpleImageLoadingListener(){

                public void onLoadingStarted(String imageUri, View view) {
                    VideoListItemHolder.this.image.setVisibility(4);
                    VideoListItemHolder.this.progress.setVisibility(0);
                }

                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                    if (!imageUri.equalsIgnoreCase(model.getImage().getFallbackSrc())) {
                        UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getFallbackSrc(), VideoListItemHolder.this.image, (ImageLoadingListener)this);
                    }
                    VideoListItemHolder.this.image.setVisibility(0);
                    VideoListItemHolder.this.progress.setVisibility(8);
                }

                public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                    VideoListItemHolder.this.image.setVisibility(0);
                    VideoListItemHolder.this.progress.setVisibility(8);
                }
            });
        }
        if (model.getEmbeddedLinks() != null) {
            this.embeddedLinksContainer.removeAllViews();
            Iterator<LinkProperty> i$ = model.getEmbeddedLinks().iterator();
            while (i$.hasNext()) {
                LinkProperty linkProperty;
                final LinkProperty property = linkProperty = i$.next();
                View embeddedLinkView = LayoutInflater.from((Context)this.embeddedLinksContainer.getContext()).inflate(R.layout.button_embedded_link, (ViewGroup)this.embeddedLinksContainer, false);
                if (embeddedLinkView == null) continue;
                Button button = (Button)embeddedLinkView.findViewById(R.id.button);
                button.setText((CharSequence)property.getTitle().getContent());
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        UiSettings.getInstance().getLinkHandler().handleLink(v.getContext(), property);
                    }
                });
                this.embeddedLinksContainer.setVisibility(0);
                this.embeddedLinksContainer.addView((View)button);
            }
        }
    }

    @Override
    public void onClick(@NonNull VideoListItem model, @NonNull View view) {
        ArrayList<VideoProperty> arrayList = new ArrayList<VideoProperty>();
        arrayList.addAll(model.getVideos());
        VideoPageDescriptor pageDescriptor = new VideoPageDescriptor();
        pageDescriptor.setType("content");
        pageDescriptor.setSrc(((VideoProperty)arrayList.get(0)).getSrc().getDestination());
        Intent video = UiSettings.getInstance().getIntentFactory().getIntentForPageDescriptor(view.getContext(), pageDescriptor);
        if (video != null) {
            video.putExtra("extra_file_name", "Video Asset");
            video.putExtra("extra_videos", arrayList);
            view.getContext().startActivity(video);
        }
    }
}

