/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.ToggleableListItem;
import com.cube.storm.ui.model.property.LinkProperty;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import java.util.Iterator;

public class ToggleableListItemHolder
extends Holder<ToggleableListItem>
implements ViewClickable<ToggleableListItem> {
    protected ViewGroup toggleContainer;
    protected ImageView expandIcon;
    protected TextView title;
    protected TextView description;
    protected LinearLayout embeddedLinksContainer;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.toggleable_list_item_view, parent, false);
        this.toggleContainer = (ViewGroup)view.findViewById(R.id.toggle_container);
        this.expandIcon = (ImageView)view.findViewById(R.id.expand_icon);
        this.title = (TextView)view.findViewById(R.id.title);
        this.description = (TextView)view.findViewById(R.id.description);
        this.embeddedLinksContainer = (LinearLayout)view.findViewById(R.id.embedded_links_container);
        return view;
    }

    @Override
    public void populateView(ToggleableListItem model) {
        String content;
        this.description.setVisibility(8);
        this.title.setVisibility(8);
        if (model.getTitle() != null && !TextUtils.isEmpty((CharSequence)(content = (String)UiSettings.getInstance().getTextProcessor().process((Object)model.getTitle().getContent())))) {
            this.title.setText((CharSequence)content);
            this.title.setVisibility(0);
        }
        if (model.getDescription() != null && !TextUtils.isEmpty((CharSequence)(content = (String)UiSettings.getInstance().getTextProcessor().process((Object)model.getDescription().getContent())))) {
            this.description.setText((CharSequence)content);
            this.description.setVisibility(0);
        }
        if (model.getEmbeddedLinks() != null) {
            this.embeddedLinksContainer.removeAllViews();
            Iterator<LinkProperty> i$ = model.getEmbeddedLinks().iterator();
            while (i$.hasNext()) {
                LinkProperty linkProperty;
                final LinkProperty property = linkProperty = i$.next();
                View embeddedLinkView = LayoutInflater.from((Context)this.embeddedLinksContainer.getContext()).inflate(R.layout.button_embedded_link, (ViewGroup)this.embeddedLinksContainer, false);
                if (embeddedLinkView == null) continue;
                Button button = (Button)embeddedLinkView.findViewById(R.id.button);
                button.setVisibility(8);
                String content2 = (String)UiSettings.getInstance().getTextProcessor().process((Object)linkProperty.getTitle().getContent());
                if (!TextUtils.isEmpty((CharSequence)content2)) {
                    button.setText((CharSequence)content2);
                    button.setVisibility(0);
                }
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        UiSettings.getInstance().getLinkHandler().handleLink(v.getContext(), property);
                    }
                });
                this.embeddedLinksContainer.setVisibility(0);
                this.embeddedLinksContainer.addView((View)button);
            }
        }
        this.toggleContainer.setVisibility(8);
    }

    @Override
    public void onClick(@NonNull ToggleableListItem model, @NonNull View view) {
        if (this.toggleContainer.getVisibility() == 8) {
            this.toggleContainer.setVisibility(0);
            this.expandIcon.setImageResource(R.drawable.ic_collapse);
        } else {
            this.toggleContainer.setVisibility(8);
            this.expandIcon.setImageResource(R.drawable.ic_expand);
        }
    }
}

