/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.ImageListItem;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

public class ImageListItemHolder
extends Holder<ImageListItem> {
    protected ImageView image;
    protected ProgressBar progress;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.image_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image);
        this.progress = (ProgressBar)view.findViewById(R.id.progress);
        return view;
    }

    @Override
    public void populateView(final ImageListItem model) {
        if (model.getImage() != null) {
            UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getSrc(), this.image, (ImageLoadingListener)new SimpleImageLoadingListener(){

                public void onLoadingStarted(String imageUri, View view) {
                    ImageListItemHolder.this.image.setVisibility(4);
                    ImageListItemHolder.this.progress.setVisibility(0);
                }

                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                    if (!imageUri.equalsIgnoreCase(model.getImage().getFallbackSrc())) {
                        UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getFallbackSrc(), ImageListItemHolder.this.image, (ImageLoadingListener)this);
                    }
                    ImageListItemHolder.this.image.setVisibility(0);
                    ImageListItemHolder.this.progress.setVisibility(8);
                }

                public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                    ImageListItemHolder.this.image.setVisibility(0);
                    ImageListItemHolder.this.progress.setVisibility(8);
                }
            });
        }
    }
}

