/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.fragment;

import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.controller.adapter.StormListAdapter;
import com.cube.storm.ui.model.Model;
import com.cube.storm.ui.model.page.Page;
import com.cube.storm.ui.view.ViewClickable;

public class StormListFragment
extends Fragment
implements AdapterView.OnItemClickListener {
    private ListView listView;
    private StormListAdapter adapter;
    private Page page;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.list_page_fragment_view, container, false);
        this.listView = (ListView)v.findViewById(16908298);
        return v;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.adapter = new StormListAdapter((Context)this.getActivity());
        if (this.getArguments().containsKey("stormui.page")) {
            this.page = (Page)this.getArguments().get("stormui.page");
        } else if (this.getArguments().containsKey("stormui.uri")) {
            String pageUri = this.getArguments().getString("stormui.uri");
            this.page = UiSettings.getInstance().getViewBuilder().buildPage(Uri.parse((String)pageUri));
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"Failed to load page", (int)0).show();
            this.getActivity().finish();
            return;
        }
        if (this.page != null) {
            this.adapter.setItems(this.page.getChildren());
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Model item = (Model)this.listView.getItemAtPosition(position);
        if (view.getTag() != null && view.getTag() instanceof ViewClickable) {
            ((ViewClickable)view.getTag()).onClick(item, view);
        }
    }

    public ListView getListView() {
        return this.listView;
    }

    public StormListAdapter getAdapter() {
        return this.adapter;
    }

    public Page getPage() {
        return this.page;
    }
}

