/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.cube.storm.ui.data.ContentDensity;
import com.cube.storm.ui.lib.factory.FileFactory;
import com.cube.storm.ui.lib.factory.IntentFactory;
import com.cube.storm.ui.lib.factory.ViewFactory;
import com.cube.storm.ui.lib.handler.LinkHandler;
import com.cube.storm.ui.lib.parser.ViewBuilder;
import com.cube.storm.ui.lib.parser.ViewProcessor;
import com.cube.storm.ui.lib.processor.TextProcessor;
import com.cube.storm.ui.model.App;
import com.cube.storm.ui.model.Model;
import com.cube.storm.ui.model.list.ListItem;
import com.cube.storm.ui.model.list.collection.CollectionItem;
import com.cube.storm.ui.model.page.Page;
import com.cube.storm.ui.model.property.ImageProperty;
import com.cube.storm.ui.model.property.LinkProperty;
import com.cube.storm.util.lib.processor.Processor;
import com.cube.storm.util.lib.resolver.AssetsResolver;
import com.cube.storm.util.lib.resolver.FileResolver;
import com.cube.storm.util.lib.resolver.Resolver;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.download.BaseImageDownloader;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class UiSettings {
    private static UiSettings instance;
    private App app;
    private IntentFactory intentFactory;
    private ViewFactory viewFactory;
    private FileFactory fileFactory;
    private Map<Class, ViewProcessor> viewProcessors = new LinkedHashMap<Class, ViewProcessor>(0);
    private ImageLoader imageLoader = ImageLoader.getInstance();
    private ContentDensity contentDensity;
    private LinkHandler linkHandler;
    private ViewBuilder viewBuilder;
    private Processor<String, String> textProcessor;
    private Map<String, Resolver> uriResolvers = new LinkedHashMap<String, Resolver>(2);

    public static UiSettings getInstance() {
        if (instance == null) {
            throw new IllegalAccessError("You must build the Ui settings object first using UiSettings$Builder");
        }
        return instance;
    }

    private UiSettings() {
    }

    public void setApp(@NonNull App app) {
        this.app = app;
    }

    public App getApp() {
        return this.app;
    }

    public IntentFactory getIntentFactory() {
        return this.intentFactory;
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public FileFactory getFileFactory() {
        return this.fileFactory;
    }

    public Map<Class, ViewProcessor> getViewProcessors() {
        return this.viewProcessors;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public ContentDensity getContentDensity() {
        return this.contentDensity;
    }

    public LinkHandler getLinkHandler() {
        return this.linkHandler;
    }

    public ViewBuilder getViewBuilder() {
        return this.viewBuilder;
    }

    public Processor<String, String> getTextProcessor() {
        return this.textProcessor;
    }

    public Map<String, Resolver> getUriResolvers() {
        return this.uriResolvers;
    }

    public static class Builder {
        private UiSettings construct = new UiSettings();
        private Context context;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
            this.intentFactory(new IntentFactory(){});
            this.viewFactory(new ViewFactory(){});
            this.fileFactory(new FileFactory(){});
            this.imageLoaderConfiguration(new ImageLoaderConfiguration.Builder(this.context));
            this.linkHandler(new LinkHandler());
            this.textProcessor(new TextProcessor());
            this.contentDensity(ContentDensity.x1_00);
            ViewProcessor<Model> baseProcessor = new ViewProcessor<Model>(){

                @Override
                public Class<? extends Model> getClassFromName(String name) {
                    return UiSettings.getInstance().getViewFactory().getModelForView(name);
                }
            };
            this.registerType(Page.class, baseProcessor);
            this.registerType(ListItem.class, baseProcessor);
            this.registerType(CollectionItem.class, baseProcessor);
            this.registerType(ImageProperty.class, baseProcessor);
            this.registerType(LinkProperty.class, baseProcessor);
            this.registerUriResolver("file", (Resolver)new FileResolver());
            this.registerUriResolver("assets", (Resolver)new AssetsResolver(this.context));
            this.viewBuilder(new ViewBuilder(){});
        }

        public Builder intentFactory(IntentFactory intentFactory) {
            this.construct.intentFactory = intentFactory;
            return this;
        }

        public Builder viewFactory(ViewFactory viewFactory) {
            this.construct.viewFactory = viewFactory;
            return this;
        }

        public Builder fileFactory(FileFactory fileFactory) {
            this.construct.fileFactory = fileFactory;
            return this;
        }

        public Builder imageLoaderConfiguration(ImageLoaderConfiguration.Builder configuration) {
            if (this.construct.imageLoader.isInited()) {
                this.construct.imageLoader.destroy();
            }
            configuration.imageDownloader((ImageDownloader)new BaseImageDownloader(this.context){

                public InputStream getStream(String imageUri, Object extra) throws IOException {
                    Uri fileUri = Uri.parse((String)imageUri);
                    if (!TextUtils.isEmpty((CharSequence)fileUri.getScheme())) {
                        for (String protocol : UiSettings.getInstance().getUriResolvers().keySet()) {
                            if (!protocol.equalsIgnoreCase(fileUri.getScheme())) continue;
                            imageUri = UiSettings.getInstance().getUriResolvers().get(protocol).resolveUri(fileUri).toString();
                        }
                    }
                    return super.getStream(imageUri, extra);
                }
            });
            this.construct.imageLoader.init(configuration.build());
            return this;
        }

        public Builder contentDensity(ContentDensity contentDensity) {
            this.construct.contentDensity = contentDensity;
            return this;
        }

        public Builder linkHandler(LinkHandler linkHandler) {
            this.construct.linkHandler = linkHandler;
            return this;
        }

        public Builder viewBuilder(ViewBuilder viewBuilder) {
            this.construct.viewBuilder = viewBuilder;
            return this;
        }

        public Builder textProcessor(Processor<String, String> textProcessor) {
            this.construct.textProcessor = textProcessor;
            return this;
        }

        public Builder registerType(Class instanceClass, ViewProcessor deserializer) {
            this.construct.viewProcessors.put(instanceClass, deserializer);
            return this;
        }

        public Builder registerUriResolver(String protocol, Resolver resolver) {
            this.construct.uriResolvers.put(protocol, resolver);
            return this;
        }

        public Builder registerUriResolver(Map<String, Resolver> resolvers) {
            this.construct.uriResolvers.putAll(resolvers);
            return this;
        }

        public UiSettings build() {
            return instance = this.construct;
        }
    }
}

