/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.ToggleableListItem;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;

public class ToggleableListItemHolder
extends Holder<ToggleableListItem>
implements ViewClickable<ToggleableListItem> {
    protected ViewGroup toggleContainer;
    protected ImageView expandIcon;
    protected TextView title;
    protected TextView description;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.toggleable_list_item_view, parent, false);
        this.toggleContainer = (ViewGroup)view.findViewById(R.id.toggle_container);
        this.expandIcon = (ImageView)view.findViewById(R.id.expand_icon);
        this.title = (TextView)view.findViewById(R.id.title);
        this.description = (TextView)view.findViewById(R.id.description);
        return view;
    }

    @Override
    public void populateView(ToggleableListItem model) {
        if (model.getTitle() != null) {
            this.title.setText((CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)model.getTitle().getContent()));
        }
        if (model.getDescription() != null && !TextUtils.isEmpty((CharSequence)model.getDescription().getContent())) {
            this.description.setText((CharSequence)UiSettings.getInstance().getTextProcessor().process((Object)model.getDescription().getContent()));
        }
        this.toggleContainer.setVisibility(8);
    }

    @Override
    public void onClick(@NonNull ToggleableListItem model, @NonNull View view) {
        if (this.toggleContainer.getVisibility() == 8) {
            this.toggleContainer.setVisibility(0);
            this.expandIcon.setImageResource(R.drawable.ic_collapse);
        } else {
            this.toggleContainer.setVisibility(8);
            this.expandIcon.setImageResource(R.drawable.ic_expand);
        }
    }
}

