/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.lib.parser;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.model.App;
import com.cube.storm.ui.model.page.Page;
import com.cube.storm.ui.model.page.TabbedPageCollection;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;

public class ViewBuilder {
    private static Gson viewBuilder;

    public void rebuild() {
        viewBuilder = null;
        this.getGson();
    }

    private Gson getGson() {
        if (viewBuilder == null) {
            GsonBuilder builder = new GsonBuilder();
            for (Class instanceClass : UiSettings.getInstance().getViewProcessors().keySet()) {
                builder.registerTypeAdapter((Type)instanceClass, (Object)UiSettings.getInstance().getViewProcessors().get(instanceClass));
            }
            viewBuilder = builder.create();
        }
        return viewBuilder;
    }

    @Nullable
    public App buildApp(@NonNull Uri fileUri) {
        byte[] appData = UiSettings.getInstance().getFileFactory().loadFromUri(fileUri);
        if (appData != null) {
            return this.buildApp(appData);
        }
        return null;
    }

    @Nullable
    public App buildApp(@NonNull byte[] app) {
        try {
            return this.build(new String(app, "UTF-8"), App.class);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public Page buildPage(@NonNull Uri fileUri) {
        byte[] pageData = UiSettings.getInstance().getFileFactory().loadFromUri(fileUri);
        if (pageData != null) {
            return this.buildPage(pageData);
        }
        return null;
    }

    @Nullable
    public Page buildPage(@NonNull byte[] page) {
        try {
            return this.build(new String(page, "UTF-8"), Page.class);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public Page buildPage(@NonNull String page) {
        return this.build(page, Page.class);
    }

    @Nullable
    public Page buildPage(@NonNull JsonElement page) {
        return this.build(page, Page.class);
    }

    @Nullable
    public TabbedPageCollection buildTabbedPage(@NonNull Uri fileUri) {
        byte[] pageData = UiSettings.getInstance().getFileFactory().loadFromUri(fileUri);
        if (pageData != null) {
            return this.buildTabbedPage(pageData);
        }
        return null;
    }

    @Nullable
    public TabbedPageCollection buildTabbedPage(@NonNull byte[] page) {
        try {
            return this.build(new String(page, "UTF-8"), TabbedPageCollection.class);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public TabbedPageCollection buildTabbedPage(@NonNull String page) {
        return this.build(page, TabbedPageCollection.class);
    }

    @Nullable
    public TabbedPageCollection buildTabbedPage(@NonNull JsonElement page) {
        return this.build(page, TabbedPageCollection.class);
    }

    @Nullable
    public <T> T build(String input, Class<T> outClass) {
        return outClass.cast(this.getGson().fromJson(input, outClass));
    }

    @Nullable
    public <T> T build(JsonElement input, Class<T> outClass) {
        return outClass.cast(this.getGson().fromJson(input, outClass));
    }
}

