/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.fragment;

import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.astuetz.PagerSlidingTabStrip;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.data.FragmentIntent;
import com.cube.storm.ui.data.FragmentPackage;
import com.cube.storm.ui.lib.adapter.StormPageAdapter;
import com.cube.storm.ui.model.descriptor.TabbedPageDescriptor;
import com.cube.storm.ui.model.page.TabbedPageCollection;
import java.util.ArrayList;

public class StormTabbedFragment
extends Fragment {
    protected StormPageAdapter pageAdapter;
    protected ViewPager viewPager;
    protected PagerSlidingTabStrip indicator;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.tabbed_page_fragment_view, container, false);
        this.viewPager = (ViewPager)view.findViewById(R.id.view_pager);
        this.indicator = (PagerSlidingTabStrip)view.findViewById(R.id.indicator);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.getArguments().containsKey("stormui.uri")) {
            String pageUri = this.getArguments().getString("stormui.uri");
            TabbedPageCollection pages = UiSettings.getInstance().getViewBuilder().buildTabbedPage(Uri.parse((String)pageUri));
            if (pages != null) {
                this.loadPages(pages);
            }
        }
    }

    protected void loadPages(@NonNull TabbedPageCollection collection) {
        this.pageAdapter = new StormPageAdapter((Context)this.getActivity(), this.getFragmentManager());
        ArrayList<FragmentPackage> fragmentPages = new ArrayList<FragmentPackage>();
        if (collection.getPages() != null) {
            for (TabbedPageDescriptor tabbedPageDescriptor : collection.getPages()) {
                FragmentIntent fragmentIntent = UiSettings.getInstance().getIntentFactory().getFragmentIntentForPageDescriptor(tabbedPageDescriptor);
                if (fragmentIntent == null) continue;
                FragmentPackage fragmentPackage = new FragmentPackage(fragmentIntent, tabbedPageDescriptor);
                fragmentPages.add(fragmentPackage);
            }
        }
        this.pageAdapter.setPages(fragmentPages);
        this.viewPager.setAdapter((PagerAdapter)this.pageAdapter);
        this.indicator.setViewPager(this.viewPager);
    }

    public StormPageAdapter getPageAdapter() {
        return this.pageAdapter;
    }
}

