/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.activity;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.data.FragmentIntent;
import com.cube.storm.ui.model.page.Page;

public class StormActivity
extends Activity {
    public static final String EXTRA_PAGE = "stormui.page";
    public static final String EXTRA_URI = "stormui.uri";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_view);
        if (this.getIntent().getExtras() == null) {
            Toast.makeText((Context)this, (CharSequence)"Failed to load page", (int)0).show();
            this.finish();
            return;
        }
        if (this.getIntent().getExtras().containsKey(EXTRA_PAGE)) {
            Page pageData = (Page)this.getIntent().getExtras().get(EXTRA_PAGE);
            if (pageData != null) {
                this.loadPage(pageData);
            }
        } else if (this.getIntent().getExtras().containsKey(EXTRA_URI)) {
            String pageUri = String.valueOf(this.getIntent().getExtras().get(EXTRA_URI));
            FragmentIntent fragmentIntent = UiSettings.getInstance().getIntentFactory().getFragmentIntentForPageUri(Uri.parse((String)pageUri));
            if (fragmentIntent != null) {
                this.loadPage(fragmentIntent);
            }
        }
    }

    protected void loadPage(Page page) {
        this.loadPage(UiSettings.getInstance().getIntentFactory().getFragmentIntentForPage(page));
    }

    protected void loadPage(FragmentIntent fragmentIntent) {
        if (fragmentIntent != null) {
            if (fragmentIntent.getArguments() == null) {
                fragmentIntent.setArguments(new Bundle());
            }
            fragmentIntent.getArguments().putAll(this.getIntent().getExtras());
            Fragment fragment = Fragment.instantiate((Context)this, (String)fragmentIntent.getFragment().getName(), (Bundle)fragmentIntent.getArguments());
            this.getFragmentManager().beginTransaction().replace(R.id.fragment_holder, fragment).commit();
            if (!TextUtils.isEmpty((CharSequence)fragmentIntent.getTitle())) {
                this.setTitle(fragmentIntent.getTitle());
            }
        }
    }
}

