/*
 * Decompiled with CFR 0.152.
 */
package co.pushe.plus.utils.keyval;

import android.content.Context;
import android.content.SharedPreferences;
import co.pushe.plus.utils.keyval.KVStorage;
import co.pushe.plus.utils.keyval.KVStorageEditor;
import java.util.ArrayList;
import java.util.Map;

public class SharedPreferencesStorage
implements KVStorage {
    private SharedPreferences sharedPreferences;

    public SharedPreferencesStorage(Context androidContext, String storeName) {
        this(androidContext.getSharedPreferences(storeName, 0));
    }

    public SharedPreferencesStorage(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public boolean contains(String key) {
        return this.sharedPreferences.contains(key);
    }

    @Override
    public String getString(String key, String defVal) {
        return this.sharedPreferences.getString(key, defVal);
    }

    @Override
    public int getInt(String key, int defVal) {
        return this.sharedPreferences.getInt(key, defVal);
    }

    @Override
    public float getFloat(String key, float defVal) {
        return this.sharedPreferences.getFloat(key, defVal);
    }

    @Override
    public boolean getBoolean(String key, boolean defVal) {
        return this.sharedPreferences.getBoolean(key, defVal);
    }

    @Override
    public String[] getStringArray(String key) {
        String valuesString = this.sharedPreferences.getString(key, "");
        String[] values = valuesString.split(",");
        ArrayList<String> valueList = new ArrayList<String>();
        for (String value : values) {
            String cleanedValue = value.trim();
            if (value.isEmpty()) continue;
            valueList.add(cleanedValue);
        }
        return valueList.toArray(new String[0]);
    }

    @Override
    public void saveString(String key, String value) {
        this.edit().putString(key, value).apply();
    }

    @Override
    public void saveInt(String key, int value) {
        this.edit().putInt(key, value).apply();
    }

    @Override
    public void saveFloat(String key, float value) {
        this.edit().putFloat(key, value).apply();
    }

    @Override
    public void saveBoolean(String key, boolean value) {
        this.edit().putBoolean(key, value).apply();
    }

    @Override
    public void saveStringArray(String key, String[] value) {
        this.edit().putStringArray(key, value).apply();
    }

    @Override
    public void remove(String key) {
        this.edit().remove(key).apply();
    }

    @Override
    public Map<String, ?> getAll() {
        return this.sharedPreferences.getAll();
    }

    @Override
    public Editor edit() {
        return new Editor(this.sharedPreferences.edit());
    }

    public static class Editor
    implements KVStorageEditor {
        private SharedPreferences.Editor editor;

        private Editor(SharedPreferences.Editor editor) {
            this.editor = editor;
        }

        @Override
        public Editor putString(String key, String value) {
            this.editor.putString(key, value);
            return this;
        }

        @Override
        public Editor putInt(String key, int value) {
            this.editor.putInt(key, value);
            return this;
        }

        @Override
        public Editor putFloat(String key, float value) {
            this.editor.putFloat(key, value);
            return this;
        }

        @Override
        public Editor putBoolean(String key, boolean value) {
            this.editor.putBoolean(key, value);
            return this;
        }

        @Override
        public Editor putStringArray(String key, String[] array) {
            if (array.length == 0) {
                this.editor.putString(key, "");
                return this;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                builder.append(',').append(array[i]);
            }
            this.editor.putString(key, builder.toString());
            return this;
        }

        @Override
        public Editor remove(String key) {
            this.editor.remove(key);
            return this;
        }

        @Override
        public void apply() {
            this.editor.apply();
        }

        @Override
        public void commit() {
            this.editor.commit();
        }
    }
}

