/*
 * Decompiled with CFR 0.152.
 */
package co.omise.android.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import co.omise.android.CardNumber;
import co.omise.android.models.CardBrand;
import co.omise.android.ui.InputValidationException;
import co.omise.android.ui.OmiseEditText;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lco/omise/android/ui/CreditCardEditText;", "Lco/omise/android/ui/OmiseEditText;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cardBrand", "Lco/omise/android/models/CardBrand;", "getCardBrand", "()Lco/omise/android/models/CardBrand;", "cardBrandImage", "Landroid/graphics/Bitmap;", "cardBrandImagePaint", "Landroid/graphics/Paint;", "cardNumber", "", "getCardNumber", "()Ljava/lang/String;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "updateCardBrandImage", "validate", "Companion", "sdk_productionRelease"})
public final class CreditCardEditText
extends OmiseEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int CARD_NUMBER_WITH_SPACE_LENGTH = 19;
    @NotNull
    private static final String SEPARATOR = " ";
    @Nullable
    private Bitmap cardBrandImage;
    @Nullable
    private Paint cardBrandImagePaint;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    public CreditCardEditText(@NotNull Context context) {
        InputFilter.LengthFilter lengthFilter;
        InputFilter.LengthFilter lengthFilter2;
        CreditCardEditText creditCardEditText = this;
        Intrinsics.checkNotNullParameter((Object)lengthFilter2, (String)"context");
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        super((Context)lengthFilter2);
        InputFilter.LengthFilter[] lengthFilterArray = new InputFilter.LengthFilter[1];
        lengthFilter2 = lengthFilter;
        lengthFilter = new InputFilter.LengthFilter(19);
        lengthFilterArray[0] = lengthFilter2;
        creditCardEditText.setFilters((InputFilter[])lengthFilterArray);
        creditCardEditText.setInputType(3);
        creditCardEditText.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ CreditCardEditText this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void beforeTextChanged(@NotNull CharSequence charSequence, int i2, int i1, int i22) {
                Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
            }

            public void onTextChanged(@NotNull CharSequence charSequence, int i2, int i1, int i22) {
                Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
            }

            /*
             * WARNING - void declaration
             */
            public void afterTextChanged(@NotNull Editable e2) {
                void var1_1;
                Editable editable = e2;
                Intrinsics.checkNotNullParameter((Object)editable, (String)"e");
                if (editable.length() == 0 || var1_1.length() % 5 != 0) {
                    return;
                }
                void v1 = var1_1;
                char c2 = v1.charAt(v1.length() - 1);
                if (Character.isDigit(c2)) {
                    void v2 = var1_1;
                    v2.insert(v2.length() - 1, (CharSequence)CreditCardEditText.SEPARATOR);
                } else if (c2 == ' ') {
                    void v3 = var1_1;
                    int n2 = v3.length() - 1;
                    v3.delete(n2, v3.length());
                }
                this.this$0.updateCardBrandImage();
            }
        });
        creditCardEditText.cardBrandImagePaint = new Paint(1);
    }

    /*
     * WARNING - void declaration
     */
    public CreditCardEditText(@NotNull Context context, @NotNull AttributeSet attrs) {
        InputFilter.LengthFilter lengthFilter;
        void var2_2;
        InputFilter.LengthFilter lengthFilter2;
        CreditCardEditText creditCardEditText = this;
        Intrinsics.checkNotNullParameter((Object)lengthFilter2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"attrs");
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        super((Context)lengthFilter2, (AttributeSet)var2_2);
        InputFilter.LengthFilter[] lengthFilterArray = new InputFilter.LengthFilter[1];
        lengthFilter2 = lengthFilter;
        lengthFilter = new InputFilter.LengthFilter(19);
        lengthFilterArray[0] = lengthFilter2;
        creditCardEditText.setFilters((InputFilter[])lengthFilterArray);
        creditCardEditText.setInputType(3);
        creditCardEditText.addTextChangedListener(new /* invalid duplicate definition of identical inner class */);
        creditCardEditText.cardBrandImagePaint = new Paint(1);
    }

    /*
     * WARNING - void declaration
     */
    public CreditCardEditText(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        InputFilter.LengthFilter lengthFilter;
        void var3_3;
        void var2_2;
        InputFilter.LengthFilter lengthFilter2;
        CreditCardEditText creditCardEditText = this;
        Intrinsics.checkNotNullParameter((Object)lengthFilter2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"attrs");
        this._$_findViewCache = new LinkedHashMap<Integer, View>();
        super((Context)lengthFilter2, (AttributeSet)var2_2, (int)var3_3);
        InputFilter.LengthFilter[] lengthFilterArray = new InputFilter.LengthFilter[1];
        lengthFilter2 = lengthFilter;
        lengthFilter = new InputFilter.LengthFilter(19);
        lengthFilterArray[0] = lengthFilter2;
        creditCardEditText.setFilters((InputFilter[])lengthFilterArray);
        creditCardEditText.setInputType(3);
        creditCardEditText.addTextChangedListener(new /* invalid duplicate definition of identical inner class */);
        creditCardEditText.cardBrandImagePaint = new Paint(1);
    }

    private final void updateCardBrandImage() {
        Object object = String.valueOf(this.getText());
        if (((String)object).length() > 6 && (object = CardNumber.brand((String)object)) != null && ((CardBrand)object).getLogoResourceId() > -1) {
            this.cardBrandImage = BitmapFactory.decodeResource((Resources)this.getResources(), (int)((CardBrand)object).getLogoResourceId());
            return;
        }
        this.cardBrandImage = null;
    }

    @NotNull
    public final String getCardNumber() {
        return StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)String.valueOf(this.getText()))).toString(), (String)SEPARATOR, (String)"", (boolean)false, (int)4, null);
    }

    @Nullable
    public final CardBrand getCardBrand() {
        return CardNumber.brand(this.getCardNumber());
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        void var1_2;
        CreditCardEditText creditCardEditText = this;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"canvas");
        super.onDraw((Canvas)var1_2);
        Bitmap bitmap = creditCardEditText.cardBrandImage;
        if (bitmap != null) {
            Bitmap bitmap2 = bitmap;
            CreditCardEditText creditCardEditText2 = this;
            float f2 = (float)creditCardEditText2.getWidth() - (float)bitmap.getWidth() - (float)this.getPaddingRight();
            float f3 = (float)(creditCardEditText2.getHeight() - bitmap.getHeight()) / 2.0f;
            bitmap = creditCardEditText2.cardBrandImagePaint;
            var1_2.drawBitmap(bitmap2, f2, f3, (Paint)bitmap);
        }
    }

    @Override
    public void validate() {
        CreditCardEditText creditCardEditText = this;
        super.validate();
        CardBrand cardBrand = creditCardEditText.getCardBrand();
        if (cardBrand != null) {
            if (CardNumber.luhn(this.getCardNumber()) && cardBrand.valid(this.getCardNumber())) {
                return;
            }
            throw InputValidationException.InvalidInputException.INSTANCE;
        }
        throw InputValidationException.InvalidInputException.INSTANCE;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public View _$_findCachedViewById(int id2) {
        void var1_1;
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get((int)var1_1);
        if (view == null) {
            view = this.findViewById((int)var1_1);
            if (view != null) {
                map.put((int)var1_1, view);
            } else {
                view = null;
            }
        }
        return view;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lco/omise/android/ui/CreditCardEditText$Companion;", "", "()V", "CARD_NUMBER_WITH_SPACE_LENGTH", "", "SEPARATOR", "", "sdk_productionRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

