/*
 * Decompiled with CFR 0.152.
 */
package co.omise.android.request;

import android.app.Activity;
import co.omise.android.models.Amount;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.Wallet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0005j\b\u0012\u0004\u0012\u00020\u0003`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0012J\b\u0010 \u001a\u00020\fH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0005j\b\u0012\u0004\u0012\u00020\u0003`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lco/omise/android/request/GooglePay;", "", "pKey", "", "cardNetworks", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "price", "", "currencyCode", "merchantId", "requestBillingAddress", "", "requestPhoneNumber", "(Ljava/lang/String;Ljava/util/ArrayList;JLjava/lang/String;Ljava/lang/String;ZZ)V", "allowedCardAuthMethods", "Lorg/json/JSONArray;", "baseRequest", "Lorg/json/JSONObject;", "gateway", "merchantInfo", "allowedCardNetworks", "baseCardPaymentMethod", "cardPaymentMethod", "createPaymentsClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "activity", "Landroid/app/Activity;", "gatewayTokenizationSpecification", "getPaymentDataRequest", "getTransactionInfo", "isReadyToPayRequest", "isTestMode", "sdk_productionRelease"})
public final class GooglePay {
    @NotNull
    private final String pKey;
    @NotNull
    private final ArrayList<String> cardNetworks;
    private final long price;
    @NotNull
    private final String currencyCode;
    private final boolean requestBillingAddress;
    private final boolean requestPhoneNumber;
    @NotNull
    private final String gateway;
    @NotNull
    private final JSONObject baseRequest;
    @NotNull
    private final JSONArray allowedCardAuthMethods;
    @NotNull
    private final JSONObject merchantInfo;

    /*
     * WARNING - void declaration
     */
    public GooglePay(@NotNull String pKey, @NotNull ArrayList<String> cardNetworks, long price, @NotNull String currencyCode, @NotNull String merchantId, boolean requestBillingAddress, boolean requestPhoneNumber) {
        void var8_7;
        void var7_6;
        void var3_3;
        void var6_5;
        void var5_4;
        void var2_2;
        void var1_1;
        GooglePay googlePay = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pKey");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"cardNetworks");
        Intrinsics.checkNotNullParameter((Object)var5_4, (String)"currencyCode");
        Intrinsics.checkNotNullParameter((Object)var6_5, (String)"merchantId");
        this.pKey = var1_1;
        this.cardNetworks = var2_2;
        this.price = var3_3;
        this.currencyCode = var5_4;
        this.requestBillingAddress = var7_6;
        googlePay.requestPhoneNumber = var8_7;
        googlePay.gateway = "omise";
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("apiVersion", 2);
        jSONObject.put("apiVersionMinor", 0);
        googlePay.baseRequest = jSONObject;
        googlePay.allowedCardAuthMethods = new JSONArray((Collection)CollectionsKt.listOf((Object)"PAN_ONLY"));
        JSONObject jSONObject2 = new JSONObject().put("merchantId", (Object)var6_5);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"JSONObject().put(\"merchantId\", merchantId)");
        googlePay.merchantInfo = jSONObject2;
    }

    public /* synthetic */ GooglePay(String string2, ArrayList arrayList, long l2, String string3, String string4, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = false;
        }
        this(string2, arrayList, l2, string3, string4, bl2, bl3);
    }

    private final JSONObject gatewayTokenizationSpecification() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("type", (Object)"PAYMENT_GATEWAY");
        JSONObject jSONObject3 = jSONObject;
        jSONObject = new JSONObject(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"gateway", (Object)this.gateway), TuplesKt.to((Object)"gatewayMerchantId", (Object)this.pKey)}));
        jSONObject2.put("parameters", (Object)jSONObject3);
        return jSONObject2;
    }

    private final JSONArray allowedCardNetworks() {
        ArrayList arrayList;
        HashMap hashMap = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"American Express", (Object)"AMEX"), TuplesKt.to((Object)"JCB", (Object)"JCB"), TuplesKt.to((Object)"MasterCard", (Object)"MASTERCARD"), TuplesKt.to((Object)"Visa", (Object)"VISA")});
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        if (((GooglePay)this).cardNetworks.isEmpty() ^ true) {
            for (String string2 : ((GooglePay)this).cardNetworks) {
                if (hashMap.get(string2) == null) continue;
                arrayList2.add(String.valueOf(hashMap.get(string2)));
            }
        } else {
            arrayList2 = CollectionsKt.arrayListOf((Object[])new String[]{"AMEX", "JCB", "MASTERCARD", "VISA"});
        }
        return new JSONArray(arrayList2);
    }

    private final JSONObject baseCardPaymentMethod() {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        JSONObject jSONObject4 = new JSONObject();
        JSONObject jSONObject5 = jSONObject3;
        jSONObject5();
        jSONObject5.put("allowedAuthMethods", (Object)this.allowedCardAuthMethods);
        jSONObject5.put("allowedCardNetworks", (Object)this.allowedCardNetworks());
        jSONObject3.put("billingAddressRequired", this.requestBillingAddress);
        JSONObject jSONObject6 = jSONObject2 = jSONObject;
        jSONObject6();
        jSONObject6.put("format", (Object)"FULL");
        jSONObject.put("phoneNumberRequired", this.requestPhoneNumber);
        jSONObject3.put("billingAddressParameters", (Object)jSONObject2);
        jSONObject4.put("type", (Object)"CARD");
        jSONObject4.put("parameters", (Object)jSONObject5);
        return jSONObject4;
    }

    private final JSONObject cardPaymentMethod() {
        JSONObject jSONObject = this.baseCardPaymentMethod();
        jSONObject.put("tokenizationSpecification", (Object)this.gatewayTokenizationSpecification());
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject getTransactionInfo(long price, String currencyCode) throws JSONException {
        void var3_2;
        void var1_1;
        Object object = new Amount((long)var1_1, (String)var3_2).toString(2);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("totalPrice", object);
        jSONObject.put("totalPriceStatus", (Object)"FINAL");
        object = var3_2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        jSONObject.put("currencyCode", object);
        return jSONObject;
    }

    private final boolean isTestMode() {
        return StringsKt.startsWith$default((String)this.pKey, (String)"pkey_test_", (boolean)false, (int)2, null);
    }

    @Nullable
    public final JSONObject isReadyToPayRequest() {
        JSONObject jSONObject = this.baseRequest;
        String string2 = "allowedPaymentMethods";
        try {
            jSONObject.put(string2, (Object)new JSONArray().put((Object)this.baseCardPaymentMethod()));
        }
        catch (JSONException jSONException) {
            jSONObject = null;
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PaymentsClient createPaymentsClient(@NotNull Activity activity) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"activity");
        int n2 = 1;
        if (this.isTestMode()) {
            n2 = 3;
        }
        Wallet.WalletOptions walletOptions = new Wallet.WalletOptions.Builder().setEnvironment(n2).build();
        Intrinsics.checkNotNullExpressionValue((Object)walletOptions, (String)"Builder()\n              \u2026\n                .build()");
        PaymentsClient paymentsClient = Wallet.getPaymentsClient((Activity)var1_2, (Wallet.WalletOptions)walletOptions);
        Intrinsics.checkNotNullExpressionValue((Object)paymentsClient, (String)"getPaymentsClient(activity, walletOptions)");
        return paymentsClient;
    }

    @Nullable
    public final JSONObject getPaymentDataRequest() {
        JSONObject jSONObject = ((GooglePay)this_).baseRequest;
        GooglePay googlePay = this_;
        JSONObject jSONObject2 = jSONObject;
        GooglePay googlePay2 = this_;
        GooglePay googlePay3 = googlePay2;
        GooglePay googlePay4 = googlePay2;
        GooglePay googlePay5 = googlePay2;
        JSONObject jSONObject3 = jSONObject;
        String string2 = "allowedPaymentMethods";
        jSONObject3.put(string2, (Object)new JSONArray().put((Object)((GooglePay)this_).cardPaymentMethod()));
        Object this_ = "transactionInfo";
        long l2 = googlePay4.price;
        String string3 = googlePay5.currencyCode;
        jSONObject2.put((String)this_, (Object)googlePay3.getTransactionInfo(l2, string3));
        this_ = "merchantInfo";
        try {
            jSONObject.put((String)this_, (Object)googlePay.merchantInfo);
        }
        catch (JSONException jSONException) {
            jSONObject = null;
        }
        return jSONObject;
    }
}

