/*
 * Decompiled with CFR 0.152.
 */
package co.omise.android.extensions;

import android.content.res.Resources;
import co.omise.android.R;
import co.omise.android.extensions.APIErrorCode;
import co.omise.android.extensions.BadRequestReason;
import co.omise.android.extensions.InvalidCardReason;
import co.omise.android.extensions.StringExtensionsKt;
import co.omise.android.models.APIError;
import co.omise.android.models.Amount;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\n\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"errorCode", "Lco/omise/android/extensions/APIErrorCode;", "Lco/omise/android/models/APIError;", "getErrorCode", "(Lco/omise/android/models/APIError;)Lco/omise/android/extensions/APIErrorCode;", "getMessageFromResources", "", "res", "Landroid/content/res/Resources;", "getMessageWhenBadRequest", "getMessageWhenInvalidCard", "sdk_productionRelease"})
public final class APIErrorExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getMessageFromResources(@NotNull APIError $this$getMessageFromResources, @NotNull Resources res) {
        void var1_2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"res");
        Object[] objectArray = APIErrorExtensionsKt.getErrorCode($this$getMessageFromResources);
        if (objectArray instanceof APIErrorCode.InvalidCard) {
            object = APIErrorExtensionsKt.getMessageWhenInvalidCard((APIError)object, (Resources)var1_2);
        } else if (objectArray instanceof APIErrorCode.BadRequest) {
            object = APIErrorExtensionsKt.getMessageWhenBadRequest((APIError)object, (Resources)var1_2);
        } else if (Intrinsics.areEqual((Object)objectArray, (Object)APIErrorCode.AuthenticationFailure.INSTANCE)) {
            object = var1_2.getString(R.string.error_api_authentication_failure);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"res.getString(R.string.e\u2026i_authentication_failure)");
        } else if (Intrinsics.areEqual((Object)objectArray, (Object)APIErrorCode.ServiceNotFound.INSTANCE)) {
            object = var1_2.getString(R.string.error_api_service_not_found);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"res.getString(R.string.e\u2026or_api_service_not_found)");
        } else {
            int n2 = R.string.error_required;
            objectArray = new Object[1];
            int n3 = 0;
            String string2 = ((APIError)object).getMessage();
            string2 = string2 != null ? StringExtensionsKt.capitalizeFirstChar(string2) : null;
            objectArray[n3] = string2;
            object = var1_2.getString(n2, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"res.getString(\n         \u2026irstChar(),\n            )");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getMessageWhenInvalidCard(@NotNull APIError $this$getMessageWhenInvalidCard, @NotNull Resources res) {
        String string2;
        void var1_2;
        APIError aPIError;
        Intrinsics.checkNotNullParameter((Object)aPIError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"res");
        APIErrorCode aPIErrorCode = APIErrorExtensionsKt.getErrorCode($this$getMessageWhenInvalidCard);
        Intrinsics.checkNotNull((Object)aPIErrorCode, (String)"null cannot be cast to non-null type co.omise.android.extensions.APIErrorCode.InvalidCard");
        Object[] objectArray = (Object[])CollectionsKt.firstOrNull(((APIErrorCode.InvalidCard)aPIErrorCode).getReasons());
        if (Intrinsics.areEqual((Object)objectArray, (Object)InvalidCardReason.InvalidCardNumber.INSTANCE)) {
            string2 = var1_2.getString(R.string.error_api_invalid_card_invalid_card_number);
        } else if (Intrinsics.areEqual((Object)objectArray, (Object)InvalidCardReason.InvalidExpirationDate.INSTANCE)) {
            string2 = var1_2.getString(R.string.error_api_invalid_card_invalid_expiration_date);
        } else if (Intrinsics.areEqual((Object)objectArray, (Object)InvalidCardReason.EmptyCardHolderName.INSTANCE)) {
            string2 = var1_2.getString(R.string.error_api_invalid_card_empty_card_holder_name);
        } else if (Intrinsics.areEqual((Object)objectArray, (Object)InvalidCardReason.UnsupportedBrand.INSTANCE)) {
            string2 = var1_2.getString(R.string.error_api_invalid_card_unsupported_brand);
        } else if (objectArray instanceof InvalidCardReason.Unknown) {
            string2 = var1_2.getString(R.string.error_required, new Object[]{((InvalidCardReason.Unknown)objectArray).getMessage()});
        } else {
            int n2 = R.string.error_required;
            objectArray = new Object[1];
            int n3 = 0;
            String string3 = aPIError.getMessage();
            string3 = string3 != null ? StringExtensionsKt.capitalizeFirstChar(string3) : null;
            objectArray[n3] = string3;
            string2 = var1_2.getString(n2, objectArray);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errorCode as APIErrorCod\u2026        )\n        }\n    }");
        return string2;
    }

    @NotNull
    public static final String getMessageWhenBadRequest(@NotNull APIError $this$getMessageWhenBadRequest, @NotNull Resources res) {
        Amount amount;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"res");
        APIErrorCode aPIErrorCode = APIErrorExtensionsKt.getErrorCode($this$getMessageWhenBadRequest);
        Intrinsics.checkNotNull((Object)aPIErrorCode, (String)"null cannot be cast to non-null type co.omise.android.extensions.APIErrorCode.BadRequest");
        Object object2 = (BadRequestReason)CollectionsKt.firstOrNull(((APIErrorCode.BadRequest)aPIErrorCode).getReasons());
        if (object2 instanceof BadRequestReason.AmountIsGreaterThanValidAmount) {
            object = (BadRequestReason.AmountIsGreaterThanValidAmount)object2;
            if (((BadRequestReason.AmountIsGreaterThanValidAmount)object).getValidAmount() != null && (object2 = ((BadRequestReason.AmountIsGreaterThanValidAmount)object).getCurrency()) != null && object2.length() != 0) {
                Amount amount2;
                void v1 = amount;
                amount = amount2;
                Object object3 = object;
                long l2 = ((BadRequestReason.AmountIsGreaterThanValidAmount)object3).getValidAmount();
                object = ((BadRequestReason.AmountIsGreaterThanValidAmount)object3).getCurrency();
                amount2 = new Amount(l2, (String)object);
                object = v1.getString(R.string.error_api_bad_request_amount_is_greater_than_valid_amount_with_valid_amount, new Object[]{amount.toAmountString()});
            } else {
                object = amount.getString(R.string.error_api_bad_request_amount_is_greater_than_valid_amount_without_valid_amount);
            }
        } else if (object2 instanceof BadRequestReason.AmountIsLessThanValidAmount) {
            object = (BadRequestReason.AmountIsLessThanValidAmount)object2;
            if (((BadRequestReason.AmountIsLessThanValidAmount)object).getValidAmount() != null && (object2 = ((BadRequestReason.AmountIsLessThanValidAmount)object).getCurrency()) != null && object2.length() != 0) {
                Amount amount3;
                Amount amount4 = amount;
                amount = amount3;
                Object object4 = object;
                long l3 = ((BadRequestReason.AmountIsLessThanValidAmount)object4).getValidAmount();
                object = ((BadRequestReason.AmountIsLessThanValidAmount)object4).getCurrency();
                amount3 = new Amount(l3, (String)object);
                object = amount4.getString(R.string.error_api_bad_request_amount_is_less_than_valid_amount_with_valid_amount, new Object[]{amount.toAmountString()});
            } else {
                object = amount.getString(R.string.error_api_bad_request_amount_is_less_than_valid_amount_without_valid_amount);
            }
        } else if (Intrinsics.areEqual((Object)object2, (Object)BadRequestReason.InvalidCurrency.INSTANCE)) {
            object = amount.getString(R.string.error_api_bad_request_invalid_currency);
        } else if (Intrinsics.areEqual((Object)object2, (Object)BadRequestReason.EmptyName.INSTANCE)) {
            object = amount.getString(R.string.error_api_bad_request_empty_name);
        } else if (object2 instanceof BadRequestReason.NameIsTooLong) {
            object = amount.getString(R.string.error_api_bad_request_name_is_too_long_with_valid_length, new Object[]{((BadRequestReason.NameIsTooLong)object2).getMaximum()});
        } else if (Intrinsics.areEqual((Object)object2, (Object)BadRequestReason.InvalidName.INSTANCE)) {
            object = amount.getString(R.string.error_api_bad_request_invalid_name);
        } else if (Intrinsics.areEqual((Object)object2, (Object)BadRequestReason.InvalidEmail.INSTANCE)) {
            object = amount.getString(R.string.error_api_bad_request_invalid_email);
        } else if (Intrinsics.areEqual((Object)object2, (Object)BadRequestReason.InvalidPhoneNumber.INSTANCE)) {
            object = amount.getString(R.string.error_api_bad_request_invalid_phone_number);
        } else if (Intrinsics.areEqual((Object)object2, (Object)BadRequestReason.SourceTypeNotSupported.INSTANCE)) {
            object = amount.getString(R.string.error_api_bad_request_source_type_not_supported);
        } else if (Intrinsics.areEqual((Object)object2, (Object)BadRequestReason.CurrencyNotSupported.INSTANCE)) {
            object = amount.getString(R.string.error_api_bad_request_currency_not_supported);
        } else if ((object = ((APIError)object).getMessage()) == null) {
            object = amount.getString(R.string.error_unknown_without_reason);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"res.getString(R.string.e\u2026r_unknown_without_reason)");
        }
        Object object5 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"errorCode as APIErrorCod\u2026t_reason)\n        }\n    }");
        return object5;
    }

    @NotNull
    public static final APIErrorCode getErrorCode(@NotNull APIError $this$errorCode) {
        Object object;
        APIError aPIError = $this$errorCode;
        Intrinsics.checkNotNullParameter((Object)aPIError, (String)"<this>");
        APIErrorCode.Companion companion = APIErrorCode.Companion;
        String string2 = aPIError.getCode();
        if (string2 == null) {
            string2 = "";
        }
        if ((object = ((APIError)object).getMessage()) == null) {
            object = "";
        }
        return companion.creator(string2, (String)object);
    }
}

