/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import co.elastic.logging.EcsJsonSerializer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;

public class EcsEncoder
extends EncoderBase<ILoggingEvent> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private boolean stackTraceAsArray = false;
    private String serviceName;
    private boolean includeMarkers = false;
    private ThrowableProxyConverter throwableProxyConverter;
    private Set<String> topLevelLabels = new HashSet<String>(EcsJsonSerializer.DEFAULT_TOP_LEVEL_LABELS);
    private boolean includeOrigin;

    public byte[] headerBytes() {
        return null;
    }

    public void start() {
        super.start();
        this.throwableProxyConverter = new ThrowableProxyConverter();
        this.throwableProxyConverter.start();
    }

    public byte[] encode(ILoggingEvent event) {
        IThrowableProxy throwableProxy;
        StackTraceElement[] callerData;
        StringBuilder builder = new StringBuilder();
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)event.getTimeStamp());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)event.getLevel().toString());
        EcsJsonSerializer.serializeFormattedMessage((StringBuilder)builder, (String)event.getFormattedMessage());
        this.serializeMarkers(event, builder);
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)event.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)event.getLoggerName());
        EcsJsonSerializer.serializeLabels((StringBuilder)builder, (Map)event.getMDCPropertyMap(), this.topLevelLabels);
        if (this.includeOrigin && (callerData = event.getCallerData()) != null && callerData.length > 0) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (StackTraceElement)callerData[0]);
        }
        if ((throwableProxy = event.getThrowableProxy()) instanceof ThrowableProxy) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)((ThrowableProxy)throwableProxy).getThrowable(), (boolean)this.stackTraceAsArray);
        } else if (throwableProxy != null) {
            EcsJsonSerializer.serializeException((StringBuilder)builder, (String)throwableProxy.getClassName(), (String)throwableProxy.getMessage(), (String)this.throwableProxyConverter.convert(event), (boolean)this.stackTraceAsArray);
        }
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder.toString().getBytes(UTF_8);
    }

    private void serializeMarkers(ILoggingEvent event, StringBuilder builder) {
        Marker marker = event.getMarker();
        if (this.includeMarkers && marker != null) {
            EcsJsonSerializer.serializeTagStart((StringBuilder)builder);
            this.serializeMarker(builder, marker);
            EcsJsonSerializer.serializeTagEnd((StringBuilder)builder);
        }
    }

    private void serializeMarker(StringBuilder builder, Marker marker) {
        if (marker != null) {
            EcsJsonSerializer.serializeSingleTag((StringBuilder)builder, (String)marker.getName());
            Iterator it = marker.iterator();
            while (it.hasNext()) {
                this.serializeMarker(builder, (Marker)it.next());
            }
        }
    }

    public byte[] footerBytes() {
        return null;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setIncludeMarkers(boolean includeMarkers) {
        this.includeMarkers = includeMarkers;
    }

    public void setStackTraceAsArray(boolean stackTraceAsArray) {
        this.stackTraceAsArray = stackTraceAsArray;
    }

    public void setIncludeOrigin(boolean includeOrigin) {
        this.includeOrigin = includeOrigin;
    }
}

