/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import jakarta.json.stream.JsonLocation;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamLocation;

public class Jackson3JsonpLocation
implements JsonLocation {
    private final TokenStreamLocation location;

    Jackson3JsonpLocation(TokenStreamLocation location) {
        this.location = location;
    }

    Jackson3JsonpLocation(JsonParser parser) {
        this(parser.currentLocation());
    }

    public long getLineNumber() {
        return this.location.getLineNr();
    }

    public long getColumnNumber() {
        return this.location.getColumnNr();
    }

    public long getStreamOffset() {
        long charOffset = this.location.getCharOffset();
        return charOffset == -1L ? this.location.getByteOffset() : charOffset;
    }

    public String toString() {
        return "(line no=" + this.location.getLineNr() + ", column no=" + this.location.getColumnNr() + ", offset=" + this.location.getCharOffset() + ")";
    }
}

