/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Pipeline;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetPipelineResponse
implements JsonpSerializable {
    private final Map<String, Pipeline> pipelines;
    public static final JsonpDeserializer<GetPipelineResponse> _DESERIALIZER = GetPipelineResponse.createGetPipelineResponseDeserializer();

    private GetPipelineResponse(Builder builder) {
        this.pipelines = ApiTypeHelper.unmodifiableRequired(builder.pipelines, (Object)this, "pipelines");
    }

    public static GetPipelineResponse of(Function<Builder, ObjectBuilder<GetPipelineResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Pipeline> pipelines() {
        return this.pipelines;
    }

    @Nullable
    public final Pipeline get(String key) {
        return this.pipelines.get(key);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        for (Map.Entry<String, Pipeline> item0 : this.pipelines.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<GetPipelineResponse> createGetPipelineResponseDeserializer() {
        JsonpDeserializer<Map<String, Pipeline>> valueDeserializer = JsonpDeserializer.stringMapDeserializer(Pipeline._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().pipelines((Map)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetPipelineResponse> {
        private Map<String, Pipeline> pipelines = new HashMap<String, Pipeline>();

        public final Builder pipelines(Map<String, Pipeline> map) {
            this.pipelines = Builder._mapPutAll(this.pipelines, map);
            return this;
        }

        public final Builder pipelines(String key, Pipeline value) {
            this.pipelines = Builder._mapPut(this.pipelines, key, value);
            return this;
        }

        public final Builder pipelines(String key, Function<Pipeline.Builder, ObjectBuilder<Pipeline>> fn) {
            return this.pipelines(key, fn.apply(new Pipeline.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Map<String, Pipeline> value = JsonpDeserializer.stringMapDeserializer(Pipeline._DESERIALIZER).deserialize(parser, mapper);
            return this.pipelines(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetPipelineResponse build() {
            this._checkSingleUse();
            return new GetPipelineResponse(this);
        }
    }
}

