/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.CompletionResult;
import co.elastic.clients.elasticsearch.inference.InferenceResultVariant;
import co.elastic.clients.elasticsearch.inference.RankedDocument;
import co.elastic.clients.elasticsearch.inference.SparseEmbeddingResult;
import co.elastic.clients.elasticsearch.inference.TextEmbeddingByteResult;
import co.elastic.clients.elasticsearch.inference.TextEmbeddingResult;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class InferenceResult
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<InferenceResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceResult::setupInferenceResultDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public InferenceResult(InferenceResultVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._inferenceResultKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private InferenceResult(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static InferenceResult of(Function<Builder, ObjectBuilder<InferenceResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTextEmbeddingBytes() {
        return this._kind == Kind.TextEmbeddingBytes;
    }

    public List<TextEmbeddingByteResult> textEmbeddingBytes() {
        return (List)TaggedUnionUtils.get(this, Kind.TextEmbeddingBytes);
    }

    public boolean isTextEmbeddingBits() {
        return this._kind == Kind.TextEmbeddingBits;
    }

    public List<TextEmbeddingByteResult> textEmbeddingBits() {
        return (List)TaggedUnionUtils.get(this, Kind.TextEmbeddingBits);
    }

    public boolean isTextEmbedding() {
        return this._kind == Kind.TextEmbedding;
    }

    public List<TextEmbeddingResult> textEmbedding() {
        return (List)TaggedUnionUtils.get(this, Kind.TextEmbedding);
    }

    public boolean isSparseEmbedding() {
        return this._kind == Kind.SparseEmbedding;
    }

    public List<SparseEmbeddingResult> sparseEmbedding() {
        return (List)TaggedUnionUtils.get(this, Kind.SparseEmbedding);
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public List<CompletionResult> completion() {
        return (List)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isRerank() {
        return this._kind == Kind.Rerank;
    }

    public List<RankedDocument> rerank() {
        return (List)TaggedUnionUtils.get(this, Kind.Rerank);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case TextEmbeddingBytes: {
                    generator.writeStartArray();
                    for (TextEmbeddingByteResult item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case TextEmbeddingBits: {
                    generator.writeStartArray();
                    for (TextEmbeddingByteResult item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case TextEmbedding: {
                    generator.writeStartArray();
                    for (TextEmbeddingResult item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case SparseEmbedding: {
                    generator.writeStartArray();
                    for (SparseEmbeddingResult item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case Completion: {
                    generator.writeStartArray();
                    for (CompletionResult item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case Rerank: {
                    generator.writeStartArray();
                    for (RankedDocument item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::textEmbeddingBytes, JsonpDeserializer.arrayDeserializer(TextEmbeddingByteResult._DESERIALIZER), "text_embedding_bytes");
        op.add(Builder::textEmbeddingBits, JsonpDeserializer.arrayDeserializer(TextEmbeddingByteResult._DESERIALIZER), "text_embedding_bits");
        op.add(Builder::textEmbedding, JsonpDeserializer.arrayDeserializer(TextEmbeddingResult._DESERIALIZER), "text_embedding");
        op.add(Builder::sparseEmbedding, JsonpDeserializer.arrayDeserializer(SparseEmbeddingResult._DESERIALIZER), "sparse_embedding");
        op.add(Builder::completion, JsonpDeserializer.arrayDeserializer(CompletionResult._DESERIALIZER), "completion");
        op.add(Builder::rerank, JsonpDeserializer.arrayDeserializer(RankedDocument._DESERIALIZER), "rerank");
    }

    public static enum Kind implements JsonEnum
    {
        TextEmbeddingBytes("text_embedding_bytes"),
        TextEmbeddingBits("text_embedding_bits"),
        TextEmbedding("text_embedding"),
        SparseEmbedding("sparse_embedding"),
        Completion("completion"),
        Rerank("rerank");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceResult> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<InferenceResult> textEmbeddingBytes(List<TextEmbeddingByteResult> v) {
            this._kind = Kind.TextEmbeddingBytes;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceResult> textEmbeddingBits(List<TextEmbeddingByteResult> v) {
            this._kind = Kind.TextEmbeddingBits;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceResult> textEmbedding(List<TextEmbeddingResult> v) {
            this._kind = Kind.TextEmbedding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceResult> sparseEmbedding(List<SparseEmbeddingResult> v) {
            this._kind = Kind.SparseEmbedding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceResult> completion(List<CompletionResult> v) {
            this._kind = Kind.Completion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceResult> rerank(List<RankedDocument> v) {
            this._kind = Kind.Rerank;
            this._value = v;
            return this;
        }

        @Override
        public InferenceResult build() {
            this._checkSingleUse();
            return new InferenceResult(this);
        }
    }
}

