/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.AmazonSageMakerApi;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AmazonSageMakerServiceSettings
implements JsonpSerializable {
    private final String accessKey;
    private final String endpointName;
    private final AmazonSageMakerApi api;
    private final String region;
    private final String secretKey;
    @Nullable
    private final String targetModel;
    @Nullable
    private final String targetContainerHostname;
    @Nullable
    private final String inferenceComponentName;
    @Nullable
    private final Integer batchSize;
    @Nullable
    private final Integer dimensions;
    public static final JsonpDeserializer<AmazonSageMakerServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AmazonSageMakerServiceSettings::setupAmazonSageMakerServiceSettingsDeserializer);

    private AmazonSageMakerServiceSettings(Builder builder) {
        this.accessKey = ApiTypeHelper.requireNonNull(builder.accessKey, this, "accessKey");
        this.endpointName = ApiTypeHelper.requireNonNull(builder.endpointName, this, "endpointName");
        this.api = ApiTypeHelper.requireNonNull(builder.api, this, "api");
        this.region = ApiTypeHelper.requireNonNull(builder.region, this, "region");
        this.secretKey = ApiTypeHelper.requireNonNull(builder.secretKey, this, "secretKey");
        this.targetModel = builder.targetModel;
        this.targetContainerHostname = builder.targetContainerHostname;
        this.inferenceComponentName = builder.inferenceComponentName;
        this.batchSize = builder.batchSize;
        this.dimensions = builder.dimensions;
    }

    public static AmazonSageMakerServiceSettings of(Function<Builder, ObjectBuilder<AmazonSageMakerServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String accessKey() {
        return this.accessKey;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final AmazonSageMakerApi api() {
        return this.api;
    }

    public final String region() {
        return this.region;
    }

    public final String secretKey() {
        return this.secretKey;
    }

    @Nullable
    public final String targetModel() {
        return this.targetModel;
    }

    @Nullable
    public final String targetContainerHostname() {
        return this.targetContainerHostname;
    }

    @Nullable
    public final String inferenceComponentName() {
        return this.inferenceComponentName;
    }

    @Nullable
    public final Integer batchSize() {
        return this.batchSize;
    }

    @Nullable
    public final Integer dimensions() {
        return this.dimensions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_key");
        generator.write(this.accessKey);
        generator.writeKey("endpoint_name");
        generator.write(this.endpointName);
        generator.writeKey("api");
        this.api.serialize(generator, mapper);
        generator.writeKey("region");
        generator.write(this.region);
        generator.writeKey("secret_key");
        generator.write(this.secretKey);
        if (this.targetModel != null) {
            generator.writeKey("target_model");
            generator.write(this.targetModel);
        }
        if (this.targetContainerHostname != null) {
            generator.writeKey("target_container_hostname");
            generator.write(this.targetContainerHostname);
        }
        if (this.inferenceComponentName != null) {
            generator.writeKey("inference_component_name");
            generator.write(this.inferenceComponentName);
        }
        if (this.batchSize != null) {
            generator.writeKey("batch_size");
            generator.write(this.batchSize.intValue());
        }
        if (this.dimensions != null) {
            generator.writeKey("dimensions");
            generator.write(this.dimensions.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAmazonSageMakerServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessKey, JsonpDeserializer.stringDeserializer(), "access_key");
        op.add(Builder::endpointName, JsonpDeserializer.stringDeserializer(), "endpoint_name");
        op.add(Builder::api, AmazonSageMakerApi._DESERIALIZER, "api");
        op.add(Builder::region, JsonpDeserializer.stringDeserializer(), "region");
        op.add(Builder::secretKey, JsonpDeserializer.stringDeserializer(), "secret_key");
        op.add(Builder::targetModel, JsonpDeserializer.stringDeserializer(), "target_model");
        op.add(Builder::targetContainerHostname, JsonpDeserializer.stringDeserializer(), "target_container_hostname");
        op.add(Builder::inferenceComponentName, JsonpDeserializer.stringDeserializer(), "inference_component_name");
        op.add(Builder::batchSize, JsonpDeserializer.integerDeserializer(), "batch_size");
        op.add(Builder::dimensions, JsonpDeserializer.integerDeserializer(), "dimensions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AmazonSageMakerServiceSettings> {
        private String accessKey;
        private String endpointName;
        private AmazonSageMakerApi api;
        private String region;
        private String secretKey;
        @Nullable
        private String targetModel;
        @Nullable
        private String targetContainerHostname;
        @Nullable
        private String inferenceComponentName;
        @Nullable
        private Integer batchSize;
        @Nullable
        private Integer dimensions;

        public final Builder accessKey(String value) {
            this.accessKey = value;
            return this;
        }

        public final Builder endpointName(String value) {
            this.endpointName = value;
            return this;
        }

        public final Builder api(AmazonSageMakerApi value) {
            this.api = value;
            return this;
        }

        public final Builder region(String value) {
            this.region = value;
            return this;
        }

        public final Builder secretKey(String value) {
            this.secretKey = value;
            return this;
        }

        public final Builder targetModel(@Nullable String value) {
            this.targetModel = value;
            return this;
        }

        public final Builder targetContainerHostname(@Nullable String value) {
            this.targetContainerHostname = value;
            return this;
        }

        public final Builder inferenceComponentName(@Nullable String value) {
            this.inferenceComponentName = value;
            return this;
        }

        public final Builder batchSize(@Nullable Integer value) {
            this.batchSize = value;
            return this;
        }

        public final Builder dimensions(@Nullable Integer value) {
            this.dimensions = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AmazonSageMakerServiceSettings build() {
            this._checkSingleUse();
            return new AmazonSageMakerServiceSettings(this);
        }
    }
}

