/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.get_data_stream_settings.DataStreamSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetDataStreamSettingsResponse
implements JsonpSerializable {
    private final List<DataStreamSettings> dataStreams;
    public static final JsonpDeserializer<GetDataStreamSettingsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDataStreamSettingsResponse::setupGetDataStreamSettingsResponseDeserializer);

    private GetDataStreamSettingsResponse(Builder builder) {
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
    }

    public static GetDataStreamSettingsResponse of(Function<Builder, ObjectBuilder<GetDataStreamSettingsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DataStreamSettings> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (DataStreamSettings item0 : this.dataStreams) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetDataStreamSettingsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(DataStreamSettings._DESERIALIZER), "data_streams");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetDataStreamSettingsResponse> {
        private List<DataStreamSettings> dataStreams;

        public final Builder dataStreams(List<DataStreamSettings> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        public final Builder dataStreams(DataStreamSettings value, DataStreamSettings ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        public final Builder dataStreams(Function<DataStreamSettings.Builder, ObjectBuilder<DataStreamSettings>> fn) {
            return this.dataStreams(fn.apply(new DataStreamSettings.Builder()).build(), new DataStreamSettings[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDataStreamSettingsResponse build() {
            this._checkSingleUse();
            return new GetDataStreamSettingsResponse(this);
        }
    }
}

