/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.core.OpenPointInTimeResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OpenPointInTimeRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowPartialSearchResults;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Nullable
    private final Query indexFilter;
    private final Time keepAlive;
    @Nullable
    private final Integer maxConcurrentShardRequests;
    @Nullable
    private final String preference;
    @Nullable
    private final String projectRouting;
    @Nullable
    private final String routing;
    public static final JsonpDeserializer<OpenPointInTimeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenPointInTimeRequest::setupOpenPointInTimeRequestDeserializer);
    public static final Endpoint<OpenPointInTimeRequest, OpenPointInTimeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<OpenPointInTimeRequest, OpenPointInTimeResponse>("es/open_point_in_time", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_pit");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.maxConcurrentShardRequests != null) {
            params.put("max_concurrent_shard_requests", String.valueOf(request.maxConcurrentShardRequests));
        }
        if (request.allowPartialSearchResults != null) {
            params.put("allow_partial_search_results", String.valueOf(request.allowPartialSearchResults));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        params.put("keep_alive", request.keepAlive._toJsonString());
        if (request.projectRouting != null) {
            params.put("project_routing", request.projectRouting);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, OpenPointInTimeResponse._DESERIALIZER);

    private OpenPointInTimeRequest(Builder builder) {
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.indexFilter = builder.indexFilter;
        this.keepAlive = ApiTypeHelper.requireNonNull(builder.keepAlive, this, "keepAlive");
        this.maxConcurrentShardRequests = builder.maxConcurrentShardRequests;
        this.preference = builder.preference;
        this.projectRouting = builder.projectRouting;
        this.routing = builder.routing;
    }

    public static OpenPointInTimeRequest of(Function<Builder, ObjectBuilder<OpenPointInTimeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Query indexFilter() {
        return this.indexFilter;
    }

    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final Integer maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final String projectRouting() {
        return this.projectRouting;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexFilter != null) {
            generator.writeKey("index_filter");
            this.indexFilter.serialize(generator, mapper);
        }
    }

    protected static void setupOpenPointInTimeRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexFilter, Query._DESERIALIZER, "index_filter");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<OpenPointInTimeRequest> {
        @Nullable
        private Boolean allowPartialSearchResults;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> index;
        @Nullable
        private Query indexFilter;
        private Time keepAlive;
        @Nullable
        private Integer maxConcurrentShardRequests;
        @Nullable
        private String preference;
        @Nullable
        private String projectRouting;
        @Nullable
        private String routing;

        public final Builder allowPartialSearchResults(@Nullable Boolean value) {
            this.allowPartialSearchResults = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder indexFilter(@Nullable Query value) {
            this.indexFilter = value;
            return this;
        }

        public final Builder indexFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.indexFilter(fn.apply(new Query.Builder()).build());
        }

        public final Builder indexFilter(QueryVariant value) {
            this.indexFilter = value._toQuery();
            return this;
        }

        public final Builder keepAlive(Time value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxConcurrentShardRequests(@Nullable Integer value) {
            this.maxConcurrentShardRequests = value;
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder projectRouting(@Nullable String value) {
            this.projectRouting = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenPointInTimeRequest build() {
            this._checkSingleUse();
            return new OpenPointInTimeRequest(this);
        }
    }
}

