/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.CustomCategorizeTextAnalyzer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CategorizeTextAnalyzer
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<CategorizeTextAnalyzer> _DESERIALIZER = JsonpDeserializer.lazy(CategorizeTextAnalyzer::buildCategorizeTextAnalyzerDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private CategorizeTextAnalyzer(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private CategorizeTextAnalyzer(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static CategorizeTextAnalyzer of(Function<Builder, ObjectBuilder<CategorizeTextAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCustom() {
        return this._kind == Kind.Custom;
    }

    public CustomCategorizeTextAnalyzer custom() {
        return (CustomCategorizeTextAnalyzer)TaggedUnionUtils.get(this, Kind.Custom);
    }

    public boolean isBuiltin() {
        return this._kind == Kind.Builtin;
    }

    public String builtin() {
        return (String)TaggedUnionUtils.get(this, Kind.Builtin);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Builtin: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<CategorizeTextAnalyzer> buildCategorizeTextAnalyzerDeserializer() {
        return new UnionDeserializer.Builder<CategorizeTextAnalyzer, Kind, Object>(CategorizeTextAnalyzer::new, false).addMember(Kind.Custom, CustomCategorizeTextAnalyzer._DESERIALIZER).addMember(Kind.Builtin, JsonpDeserializer.stringDeserializer()).build();
    }

    public static enum Kind {
        Custom,
        Builtin;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CategorizeTextAnalyzer> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<CategorizeTextAnalyzer> custom(CustomCategorizeTextAnalyzer v) {
            this._kind = Kind.Custom;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CategorizeTextAnalyzer> custom(Function<CustomCategorizeTextAnalyzer.Builder, ObjectBuilder<CustomCategorizeTextAnalyzer>> fn) {
            return this.custom(fn.apply(new CustomCategorizeTextAnalyzer.Builder()).build());
        }

        public ObjectBuilder<CategorizeTextAnalyzer> builtin(String v) {
            this._kind = Kind.Builtin;
            this._value = v;
            return this;
        }

        @Override
        public CategorizeTextAnalyzer build() {
            this._checkSingleUse();
            return new CategorizeTextAnalyzer(this);
        }
    }
}

