/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GoogleVertexAIServiceSettings
implements JsonpSerializable {
    private final String location;
    private final String modelId;
    private final String projectId;
    @Nullable
    private final RateLimitSetting rateLimit;
    private final String serviceAccountJson;
    @Nullable
    private final Integer dimensions;
    public static final JsonpDeserializer<GoogleVertexAIServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GoogleVertexAIServiceSettings::setupGoogleVertexAIServiceSettingsDeserializer);

    private GoogleVertexAIServiceSettings(Builder builder) {
        this.location = ApiTypeHelper.requireNonNull(builder.location, this, "location");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.projectId = ApiTypeHelper.requireNonNull(builder.projectId, this, "projectId");
        this.rateLimit = builder.rateLimit;
        this.serviceAccountJson = ApiTypeHelper.requireNonNull(builder.serviceAccountJson, this, "serviceAccountJson");
        this.dimensions = builder.dimensions;
    }

    public static GoogleVertexAIServiceSettings of(Function<Builder, ObjectBuilder<GoogleVertexAIServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String location() {
        return this.location;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String projectId() {
        return this.projectId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    public final String serviceAccountJson() {
        return this.serviceAccountJson;
    }

    @Nullable
    public final Integer dimensions() {
        return this.dimensions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("location");
        generator.write(this.location);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("project_id");
        generator.write(this.projectId);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        generator.writeKey("service_account_json");
        generator.write(this.serviceAccountJson);
        if (this.dimensions != null) {
            generator.writeKey("dimensions");
            generator.write(this.dimensions.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGoogleVertexAIServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::location, JsonpDeserializer.stringDeserializer(), "location");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::projectId, JsonpDeserializer.stringDeserializer(), "project_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::serviceAccountJson, JsonpDeserializer.stringDeserializer(), "service_account_json");
        op.add(Builder::dimensions, JsonpDeserializer.integerDeserializer(), "dimensions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GoogleVertexAIServiceSettings> {
        private String location;
        private String modelId;
        private String projectId;
        @Nullable
        private RateLimitSetting rateLimit;
        private String serviceAccountJson;
        @Nullable
        private Integer dimensions;

        public final Builder location(String value) {
            this.location = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder projectId(String value) {
            this.projectId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder serviceAccountJson(String value) {
            this.serviceAccountJson = value;
            return this;
        }

        public final Builder dimensions(@Nullable Integer value) {
            this.dimensions = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GoogleVertexAIServiceSettings build() {
            this._checkSingleUse();
            return new GoogleVertexAIServiceSettings(this);
        }
    }
}

