/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch.indices.remove_block.RemoveIndicesBlockStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RemoveBlockResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final List<RemoveIndicesBlockStatus> indices;
    public static final JsonpDeserializer<RemoveBlockResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveBlockResponse::setupRemoveBlockResponseDeserializer);

    private RemoveBlockResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, (Object)this, "acknowledged", false);
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static RemoveBlockResponse of(Function<Builder, ObjectBuilder<RemoveBlockResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final List<RemoveIndicesBlockStatus> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (RemoveIndicesBlockStatus item0 : this.indices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRemoveBlockResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(RemoveIndicesBlockStatus._DESERIALIZER), "indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RemoveBlockResponse> {
        private Boolean acknowledged;
        private List<RemoveIndicesBlockStatus> indices;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder indices(List<RemoveIndicesBlockStatus> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(RemoveIndicesBlockStatus value, RemoveIndicesBlockStatus ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<RemoveIndicesBlockStatus.Builder, ObjectBuilder<RemoveIndicesBlockStatus>> fn) {
            return this.indices(fn.apply(new RemoveIndicesBlockStatus.Builder()).build(), new RemoveIndicesBlockStatus[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoveBlockResponse build() {
            this._checkSingleUse();
            return new RemoveBlockResponse(this);
        }
    }
}

