/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.http.HeaderMap;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DefaultTransportOptions
implements TransportOptions {
    private final HeaderMap headers;
    private final Map<String, String> parameters;
    private final Function<List<String>, Boolean> onWarnings;
    private boolean keepResponseBodyOnException;
    public static final DefaultTransportOptions EMPTY = new DefaultTransportOptions();

    public DefaultTransportOptions() {
        this(new HeaderMap(), Collections.emptyMap(), null);
    }

    public DefaultTransportOptions(@Nullable HeaderMap headers, @Nullable Map<String, String> parameters, @Nullable Function<List<String>, Boolean> onWarnings, boolean keepResponseBodyOnException) {
        this(headers, parameters, onWarnings);
        this.keepResponseBodyOnException = keepResponseBodyOnException;
    }

    public DefaultTransportOptions(@Nullable HeaderMap headers, @Nullable Map<String, String> parameters, @Nullable Function<List<String>, Boolean> onWarnings) {
        this.headers = headers == null ? HeaderMap.EMPTY : headers;
        this.parameters = parameters == null || parameters.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(parameters);
        this.onWarnings = onWarnings;
        this.keepResponseBodyOnException = false;
    }

    protected DefaultTransportOptions(AbstractBuilder<?> builder) {
        this(builder.headers, builder.parameters, builder.onWarnings, builder.keepResponseBodyOnException);
    }

    public static DefaultTransportOptions of(@Nullable TransportOptions options) {
        if (options == null) {
            return new DefaultTransportOptions(null, null, null);
        }
        if (options instanceof DefaultTransportOptions) {
            return (DefaultTransportOptions)options;
        }
        return new DefaultTransportOptions(new HeaderMap(DefaultTransportOptions.entriesToMap(options.headers())), options.queryParameters(), options.onWarnings());
    }

    @Override
    public Collection<Map.Entry<String, String>> headers() {
        return Collections.unmodifiableSet(this.headers.entrySet());
    }

    @Override
    public Map<String, String> queryParameters() {
        return this.parameters;
    }

    @Override
    public Function<List<String>, Boolean> onWarnings() {
        return this.onWarnings;
    }

    @Override
    public void updateToken(String token) {
        this.headers.put("Authorization", "Bearer " + token);
    }

    @Override
    public boolean keepResponseBodyOnException() {
        return this.keepResponseBodyOnException;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    private static <K, V> Map<K, V> entriesToMap(Collection<Map.Entry<K, V>> entries) {
        if (entries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase
    implements TransportOptions.Builder {
        private HeaderMap headers;
        private Map<String, String> parameters;
        private Function<List<String>, Boolean> onWarnings;
        private boolean keepResponseBodyOnException;

        public AbstractBuilder() {
        }

        public AbstractBuilder(DefaultTransportOptions options) {
            this.headers = new HeaderMap(options.headers);
            this.parameters = this.copyOrNull(options.parameters);
            this.onWarnings = options.onWarnings;
            this.keepResponseBodyOnException = options.keepResponseBodyOnException;
        }

        protected abstract BuilderT self();

        public BuilderT keepResponseBodyOnException(boolean value) {
            this.keepResponseBodyOnException = value;
            return this.self();
        }

        public BuilderT addHeader(String name, String value) {
            if (name.equalsIgnoreCase("X-Elastic-Client-Meta")) {
                return this.self();
            }
            if (this.headers == null) {
                this.headers = new HeaderMap();
            }
            this.headers.add(name, value);
            return this.self();
        }

        public BuilderT setHeader(String name, String value) {
            if (name.equalsIgnoreCase("X-Elastic-Client-Meta")) {
                return this.self();
            }
            if (this.headers == null) {
                this.headers = new HeaderMap();
            }
            this.headers.put(name, value);
            return this.self();
        }

        public BuilderT removeHeader(String name) {
            if (this.headers != null) {
                this.headers.remove(name);
            }
            return this.self();
        }

        public BuilderT setParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            this.parameters.put(name, value);
            return this.self();
        }

        public BuilderT removeParameter(String name) {
            if (this.parameters != null) {
                this.parameters.remove(name);
            }
            return this.self();
        }

        public BuilderT onWarnings(Function<List<String>, Boolean> listener) {
            this.onWarnings = listener;
            return this.self();
        }

        private <K, V> Map<K, V> copyOrNull(Map<K, V> map) {
            return map.isEmpty() ? null : new HashMap<K, V>(map);
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder() {
        }

        public Builder(DefaultTransportOptions options) {
            super(options);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransportOptions build() {
            this._checkSingleUse();
            return new DefaultTransportOptions(this);
        }
    }
}

