/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch_template;

import co.elastic.clients.elasticsearch._types.ScriptSource;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TemplateConfig
implements JsonpSerializable {
    @Nullable
    private final Boolean explain;
    @Nullable
    private final String id;
    private final Map<String, JsonData> params;
    @Nullable
    private final Boolean profile;
    @Nullable
    private final ScriptSource source;
    public static final JsonpDeserializer<TemplateConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TemplateConfig::setupTemplateConfigDeserializer);

    private TemplateConfig(Builder builder) {
        this.explain = builder.explain;
        this.id = builder.id;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.profile = builder.profile;
        this.source = builder.source;
    }

    public static TemplateConfig of(Function<Builder, ObjectBuilder<TemplateConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final Boolean profile() {
        return this.profile;
    }

    @Nullable
    public final ScriptSource source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTemplateConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile");
        op.add(Builder::source, ScriptSource._DESERIALIZER, "source");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TemplateConfig> {
        @Nullable
        private Boolean explain;
        @Nullable
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private Boolean profile;
        @Nullable
        private ScriptSource source;

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public final Builder source(@Nullable ScriptSource value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<ScriptSource.Builder, ObjectBuilder<ScriptSource>> fn) {
            return this.source(fn.apply(new ScriptSource.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TemplateConfig build() {
            this._checkSingleUse();
            return new TemplateConfig(this);
        }
    }
}

