/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FieldDateMath
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<FieldDateMath> _DESERIALIZER = JsonpDeserializer.lazy(FieldDateMath::buildFieldDateMathDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private FieldDateMath(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Expr: {
                return this.expr();
            }
            case Value: {
                return String.valueOf(this.value());
            }
        }
        throw new IllegalStateException("Unknown kind " + String.valueOf((Object)this._kind));
    }

    private FieldDateMath(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static FieldDateMath of(Function<Builder, ObjectBuilder<FieldDateMath>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isExpr() {
        return this._kind == Kind.Expr;
    }

    public String expr() {
        return (String)TaggedUnionUtils.get(this, Kind.Expr);
    }

    public boolean isValue() {
        return this._kind == Kind.Value;
    }

    public Double value() {
        return (Double)TaggedUnionUtils.get(this, Kind.Value);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Expr: {
                    generator.write((String)this._value);
                    break;
                }
                case Value: {
                    generator.write(((Double)this._value).doubleValue());
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<FieldDateMath> buildFieldDateMathDeserializer() {
        return new UnionDeserializer.Builder<FieldDateMath, Kind, Object>(FieldDateMath::new, false).addMember(Kind.Expr, JsonpDeserializer.stringDeserializer()).addMember(Kind.Value, JsonpDeserializer.doubleDeserializer()).build();
    }

    public static enum Kind {
        Expr,
        Value;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FieldDateMath> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<FieldDateMath> expr(String v) {
            this._kind = Kind.Expr;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldDateMath> value(Double v) {
            this._kind = Kind.Value;
            this._value = v;
            return this;
        }

        @Override
        public FieldDateMath build() {
            this._checkSingleUse();
            return new FieldDateMath(this);
        }
    }
}

