/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.http;

import co.elastic.clients.transport.DefaultTransportOptions;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.BinaryData;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public interface TransportHttpClient {
    default public TransportOptions createOptions(@Nullable TransportOptions options) {
        return options == null ? DefaultTransportOptions.EMPTY : options;
    }

    public Response performRequest(String var1, @Nullable Node var2, Request var3, TransportOptions var4) throws IOException;

    public CompletableFuture<Response> performRequestAsync(String var1, @Nullable Node var2, Request var3, TransportOptions var4);

    public void close() throws IOException;

    public static class Node {
        private final URI uri;
        private final String name;
        private final String version;
        private final Set<String> roles;
        private final Map<String, String> attributes;

        public Node(URI uri, @Nullable String name, @Nullable String version, @Nullable Set<String> roles, @Nullable Map<String, String> attributes) {
            if (!uri.isAbsolute()) {
                throw new IllegalArgumentException("Node URIs must be absolute: " + String.valueOf(uri));
            }
            if (!uri.getRawPath().endsWith("/")) {
                uri = uri.resolve(uri.getRawPath() + "/");
            }
            this.uri = uri;
            this.name = name;
            this.version = version;
            this.roles = roles;
            this.attributes = attributes;
        }

        public Node(URI uri) {
            this(uri, null, null, null, null);
        }

        public Node(String uri) {
            this(URI.create(uri), null, null, null, null);
        }

        public URI uri() {
            return this.uri;
        }

        @Nullable
        public String name() {
            return this.name;
        }

        @Nullable
        public String version() {
            return this.version;
        }

        @Nullable
        public Set<String> roles() {
            return this.roles;
        }

        @Nullable
        public Map<String, String> attributes() {
            return this.attributes;
        }

        public String toString() {
            return this.uri.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.uri, node.uri);
        }

        public int hashCode() {
            return Objects.hash(this.uri);
        }
    }

    public static interface Response
    extends Closeable {
        public Node node();

        public int statusCode();

        @Nullable
        public String header(String var1);

        public List<String> headers(String var1);

        @Nullable
        public BinaryData body() throws IOException;

        @Nullable
        public Object originalResponse();

        @Override
        public void close() throws IOException;
    }

    public static class Request {
        @Nullable
        private final String method;
        private final String path;
        private final Map<String, String> queryParams;
        private final Map<String, String> headers;
        @Nullable
        private final Iterable<ByteBuffer> body;

        public Request(String method, String path, Map<String, String> queryParams, Map<String, String> headers, @Nullable Iterable<ByteBuffer> body) {
            this.method = method;
            this.path = path;
            this.queryParams = queryParams;
            this.headers = headers;
            this.body = body;
        }

        public String method() {
            return this.method;
        }

        public String path() {
            return this.path;
        }

        public Map<String, String> queryParams() {
            return this.queryParams;
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        @Nullable
        public Iterable<ByteBuffer> body() {
            return this.body;
        }
    }
}

