/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutTrainedModelDefinitionPartResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class PutTrainedModelDefinitionPartRequest
extends RequestBase
implements JsonpSerializable {
    private final String definition;
    private final String modelId;
    private final int part;
    private final long totalDefinitionLength;
    private final int totalParts;
    public static final JsonpDeserializer<PutTrainedModelDefinitionPartRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTrainedModelDefinitionPartRequest::setupPutTrainedModelDefinitionPartRequestDeserializer);
    public static final Endpoint<PutTrainedModelDefinitionPartRequest, PutTrainedModelDefinitionPartResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutTrainedModelDefinitionPartRequest, PutTrainedModelDefinitionPartResponse>("es/ml.put_trained_model_definition_part", request -> "PUT", request -> {
        boolean _part = true;
        int _modelId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/definition");
            buf.append("/");
            SimpleEndpoint.pathEncode(String.valueOf(request.part), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _part = true;
        int _modelId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("modelId", request.modelId);
            params.put("part", String.valueOf(request.part));
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutTrainedModelDefinitionPartResponse._DESERIALIZER);

    private PutTrainedModelDefinitionPartRequest(Builder builder) {
        this.definition = ApiTypeHelper.requireNonNull(builder.definition, this, "definition");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.part = ApiTypeHelper.requireNonNull(builder.part, (Object)this, "part", 0);
        this.totalDefinitionLength = ApiTypeHelper.requireNonNull(builder.totalDefinitionLength, (Object)this, "totalDefinitionLength", 0L);
        this.totalParts = ApiTypeHelper.requireNonNull(builder.totalParts, (Object)this, "totalParts", 0);
    }

    public static PutTrainedModelDefinitionPartRequest of(Function<Builder, ObjectBuilder<PutTrainedModelDefinitionPartRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String definition() {
        return this.definition;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final int part() {
        return this.part;
    }

    public final long totalDefinitionLength() {
        return this.totalDefinitionLength;
    }

    public final int totalParts() {
        return this.totalParts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("definition");
        generator.write(this.definition);
        generator.writeKey("total_definition_length");
        generator.write(this.totalDefinitionLength);
        generator.writeKey("total_parts");
        generator.write(this.totalParts);
    }

    protected static void setupPutTrainedModelDefinitionPartRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::definition, JsonpDeserializer.stringDeserializer(), "definition");
        op.add(Builder::totalDefinitionLength, JsonpDeserializer.longDeserializer(), "total_definition_length");
        op.add(Builder::totalParts, JsonpDeserializer.integerDeserializer(), "total_parts");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutTrainedModelDefinitionPartRequest> {
        private String definition;
        private String modelId;
        private Integer part;
        private Long totalDefinitionLength;
        private Integer totalParts;

        public final Builder definition(String value) {
            this.definition = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder part(int value) {
            this.part = value;
            return this;
        }

        public final Builder totalDefinitionLength(long value) {
            this.totalDefinitionLength = value;
            return this;
        }

        public final Builder totalParts(int value) {
            this.totalParts = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutTrainedModelDefinitionPartRequest build() {
            this._checkSingleUse();
            return new PutTrainedModelDefinitionPartRequest(this);
        }
    }
}

