/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluationMetrics;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeEvaluationOutlierDetectionMetrics
extends DataframeEvaluationMetrics {
    private final Map<String, JsonData> confusionMatrix;
    public static final JsonpDeserializer<DataframeEvaluationOutlierDetectionMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeEvaluationOutlierDetectionMetrics::setupDataframeEvaluationOutlierDetectionMetricsDeserializer);

    private DataframeEvaluationOutlierDetectionMetrics(Builder builder) {
        super(builder);
        this.confusionMatrix = ApiTypeHelper.unmodifiable(builder.confusionMatrix);
    }

    public static DataframeEvaluationOutlierDetectionMetrics of(Function<Builder, ObjectBuilder<DataframeEvaluationOutlierDetectionMetrics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> confusionMatrix() {
        return this.confusionMatrix;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.confusionMatrix)) {
            generator.writeKey("confusion_matrix");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.confusionMatrix.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDataframeEvaluationOutlierDetectionMetricsDeserializer(ObjectDeserializer<Builder> op) {
        DataframeEvaluationMetrics.setupDataframeEvaluationMetricsDeserializer(op);
        op.add(Builder::confusionMatrix, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "confusion_matrix");
    }

    public static class Builder
    extends DataframeEvaluationMetrics.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeEvaluationOutlierDetectionMetrics> {
        @Nullable
        private Map<String, JsonData> confusionMatrix;

        public final Builder confusionMatrix(Map<String, JsonData> map) {
            this.confusionMatrix = Builder._mapPutAll(this.confusionMatrix, map);
            return this;
        }

        public final Builder confusionMatrix(String key, JsonData value) {
            this.confusionMatrix = Builder._mapPut(this.confusionMatrix, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeEvaluationOutlierDetectionMetrics build() {
            this._checkSingleUse();
            return new DataframeEvaluationOutlierDetectionMetrics(this);
        }
    }
}

