/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.MistralServiceSettings;
import co.elastic.clients.elasticsearch.inference.MistralServiceType;
import co.elastic.clients.elasticsearch.inference.MistralTaskType;
import co.elastic.clients.elasticsearch.inference.PutMistralResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutMistralRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String mistralInferenceId;
    private final MistralServiceType service;
    private final MistralServiceSettings serviceSettings;
    private final MistralTaskType taskType;
    public static final JsonpDeserializer<PutMistralRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutMistralRequest::setupPutMistralRequestDeserializer);
    public static final Endpoint<PutMistralRequest, PutMistralResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutMistralRequest, PutMistralResponse>("es/inference.put_mistral", request -> "PUT", request -> {
        boolean _mistralInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.mistralInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _mistralInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("mistralInferenceId", request.mistralInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutMistralResponse._DESERIALIZER);

    private PutMistralRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.mistralInferenceId = ApiTypeHelper.requireNonNull(builder.mistralInferenceId, this, "mistralInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static PutMistralRequest of(Function<Builder, ObjectBuilder<PutMistralRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String mistralInferenceId() {
        return this.mistralInferenceId;
    }

    public final MistralServiceType service() {
        return this.service;
    }

    public final MistralServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final MistralTaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    protected static void setupPutMistralRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, MistralServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, MistralServiceSettings._DESERIALIZER, "service_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutMistralRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String mistralInferenceId;
        private MistralServiceType service;
        private MistralServiceSettings serviceSettings;
        private MistralTaskType taskType;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder mistralInferenceId(String value) {
            this.mistralInferenceId = value;
            return this;
        }

        public final Builder service(MistralServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(MistralServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<MistralServiceSettings.Builder, ObjectBuilder<MistralServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new MistralServiceSettings.Builder()).build());
        }

        public final Builder taskType(MistralTaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutMistralRequest build() {
            this._checkSingleUse();
            return new PutMistralRequest(this);
        }
    }
}

