/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.query_user.QueryUser;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class QueryUserResponse
implements JsonpSerializable {
    private final int total;
    private final int count;
    private final List<QueryUser> users;
    public static final JsonpDeserializer<QueryUserResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryUserResponse::setupQueryUserResponseDeserializer);

    private QueryUserResponse(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0);
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.users = ApiTypeHelper.unmodifiableRequired(builder.users, (Object)this, "users");
    }

    public static QueryUserResponse of(Function<Builder, ObjectBuilder<QueryUserResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int total() {
        return this.total;
    }

    public final int count() {
        return this.count;
    }

    public final List<QueryUser> users() {
        return this.users;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.users)) {
            generator.writeKey("users");
            generator.writeStartArray();
            for (QueryUser item0 : this.users) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryUserResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::users, JsonpDeserializer.arrayDeserializer(QueryUser._DESERIALIZER), "users");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryUserResponse> {
        private Integer total;
        private Integer count;
        private List<QueryUser> users;

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder users(List<QueryUser> list) {
            this.users = Builder._listAddAll(this.users, list);
            return this;
        }

        public final Builder users(QueryUser value, QueryUser ... values) {
            this.users = Builder._listAdd(this.users, value, values);
            return this;
        }

        public final Builder users(Function<QueryUser.Builder, ObjectBuilder<QueryUser>> fn) {
            return this.users(fn.apply(new QueryUser.Builder()).build(), new QueryUser[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryUserResponse build() {
            this._checkSingleUse();
            return new QueryUserResponse(this);
        }
    }
}

