/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.transforms.TransformsRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TransformsResponse
implements JsonpSerializable {
    private final List<TransformsRecord> transforms;
    public static final JsonpDeserializer<TransformsResponse> _DESERIALIZER = TransformsResponse.createTransformsResponseDeserializer();

    private TransformsResponse(Builder builder) {
        this.transforms = ApiTypeHelper.unmodifiableRequired(builder.transforms, (Object)this, "transforms");
    }

    public static TransformsResponse of(Function<Builder, ObjectBuilder<TransformsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<TransformsRecord> transforms() {
        return this.transforms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (TransformsRecord item0 : this.transforms) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<TransformsResponse> createTransformsResponseDeserializer() {
        JsonpDeserializer<List<TransformsRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(TransformsRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().transforms((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformsResponse> {
        private List<TransformsRecord> transforms;

        public final Builder transforms(List<TransformsRecord> list) {
            this.transforms = Builder._listAddAll(this.transforms, list);
            return this;
        }

        public final Builder transforms(TransformsRecord value, TransformsRecord ... values) {
            this.transforms = Builder._listAdd(this.transforms, value, values);
            return this;
        }

        public final Builder transforms(Function<TransformsRecord.Builder, ObjectBuilder<TransformsRecord>> fn) {
            return this.transforms(fn.apply(new TransformsRecord.Builder()).build(), new TransformsRecord[0]);
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            List<TransformsRecord> value = JsonpDeserializer.arrayDeserializer(TransformsRecord._DESERIALIZER).deserialize(parser, mapper);
            return this.transforms(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformsResponse build() {
            this._checkSingleUse();
            return new TransformsResponse(this);
        }
    }
}

