/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.DefaultTransportOptions;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.instrumentation.Instrumentation;
import co.elastic.clients.transport.rest5_client.Rest5ClientTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;

public abstract class ElasticsearchTransportConfig {
    protected List<URI> hosts;
    protected String username;
    protected String password;
    protected String token;
    protected String apiKey;
    protected boolean useCompression = false;
    protected SSLContext sslContext;
    protected JsonpMapper mapper;
    protected TransportOptions transportOptions;
    protected Instrumentation instrumentation;

    public List<URI> hosts() {
        return this.hosts;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    @Nullable
    public String token() {
        return this.token;
    }

    @Nullable
    public String apiKey() {
        return this.apiKey;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    @Nullable
    public SSLContext sslContext() {
        return this.sslContext;
    }

    public JsonpMapper mapper() {
        return this.mapper;
    }

    public TransportOptions transportOptions() {
        return this.transportOptions;
    }

    @Nullable
    public Instrumentation instrumentation() {
        return this.instrumentation;
    }

    public abstract ElasticsearchTransport buildTransport();

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        protected final ElasticsearchTransportConfig config;

        public AbstractBuilder(ElasticsearchTransportConfig config) {
            this.config = config;
        }

        protected abstract BuilderT self();

        protected ElasticsearchTransportConfig build() {
            if (this.config.username != null) {
                this.checkNull(this.config.token, "token", "username/password");
                this.checkNull(this.config.apiKey, "API key", "username/password");
                if (this.config.password == null) {
                    throw new IllegalArgumentException("password required with username");
                }
            } else if (this.config.password != null) {
                throw new IllegalArgumentException("username required with password");
            }
            if (this.config.token != null) {
                this.checkNull(this.config.apiKey, "API key", "token");
                this.checkNull(this.config.username, "username", "token");
            }
            if (this.config.apiKey != null) {
                this.checkNull(this.config.token, "token", "API key");
                this.checkNull(this.config.username, "username", "API key");
            }
            if (this.config.hosts() == null || this.config.hosts.isEmpty()) {
                throw new IllegalArgumentException("hosts cannot be empty");
            }
            if (this.config.mapper == null) {
                this.config.mapper = new JacksonJsonpMapper();
            }
            return this.config;
        }

        public BuilderT host(String url) {
            try {
                this.config.hosts = List.of(new URI(url));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return this.self();
        }

        public BuilderT host(URI url) {
            this.config.hosts = List.of(url);
            return this.self();
        }

        public BuilderT hosts(List<URI> hosts) {
            this.config.hosts = hosts;
            return this.self();
        }

        public BuilderT usernameAndPassword(String username, String password) {
            this.config.username = username;
            this.config.password = password;
            return this.self();
        }

        public BuilderT token(String token) {
            this.config.token = token;
            return this.self();
        }

        public BuilderT apiKey(String apiKey) {
            this.config.apiKey = apiKey;
            return this.self();
        }

        public BuilderT useCompression(boolean useCompression) {
            this.config.useCompression = useCompression;
            return this.self();
        }

        public BuilderT sslContext(SSLContext sslContext) {
            this.config.sslContext = sslContext;
            return this.self();
        }

        public BuilderT jsonMapper(JsonpMapper mapper) {
            this.config.mapper = mapper;
            return this.self();
        }

        public BuilderT instrumentation(Instrumentation instrumentation) {
            this.config.instrumentation = instrumentation;
            return this.self();
        }

        public BuilderT transportOptions(TransportOptions transportOptions) {
            this.config.transportOptions = transportOptions;
            return this.self();
        }

        public BuilderT transportOptions(Function<TransportOptions.Builder, TransportOptions.Builder> fn) {
            TransportOptions.Builder builder = this.config.transportOptions == null ? new DefaultTransportOptions.Builder() : this.config.transportOptions.toBuilder();
            this.config.transportOptions = (TransportOptions)fn.apply(builder).build();
            return this.self();
        }

        protected void checkNull(Object value, String name, String other) {
            if (value != null) {
                throw new IllegalArgumentException("Cannot set both " + other + " and " + name + ".");
            }
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        private final Default dconfig;

        public Builder() {
            this(new Default());
        }

        private Builder(Default dconfig) {
            super(dconfig);
            this.dconfig = dconfig;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder useLegacyTransport(boolean useLegacyTransport) {
            this.dconfig.transportFactory = useLegacyTransport ? RestClientTransport::new : null;
            return this;
        }

        public Builder transportFactory(Function<ElasticsearchTransportConfig, ElasticsearchTransport> factory) {
            this.dconfig.transportFactory = factory;
            return this;
        }

        @Override
        public Default build() {
            Default config = (Default)super.build();
            if (config.transportFactory == null) {
                config.transportFactory = Rest5ClientTransport::new;
            }
            return config;
        }
    }

    public static class Default
    extends ElasticsearchTransportConfig {
        protected Function<ElasticsearchTransportConfig, ElasticsearchTransport> transportFactory;

        public Function<ElasticsearchTransportConfig, ElasticsearchTransport> transportFactory() {
            return this.transportFactory;
        }

        @Override
        public ElasticsearchTransport buildTransport() {
            return this.transportFactory.apply(this);
        }
    }
}

