/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class AsyncSearchResponseBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final boolean isPartial;
    private final boolean isRunning;
    @Nullable
    private final DateTime expirationTime;
    private final long expirationTimeInMillis;
    @Nullable
    private final DateTime startTime;
    private final long startTimeInMillis;
    @Nullable
    private final DateTime completionTime;
    @Nullable
    private final Long completionTimeInMillis;

    protected AsyncSearchResponseBase(AbstractBuilder<?> builder) {
        this.id = builder.id;
        this.isPartial = ApiTypeHelper.requireNonNull(builder.isPartial, (Object)this, "isPartial", false);
        this.isRunning = ApiTypeHelper.requireNonNull(builder.isRunning, (Object)this, "isRunning", false);
        this.expirationTime = builder.expirationTime;
        this.expirationTimeInMillis = ApiTypeHelper.requireNonNull(builder.expirationTimeInMillis, (Object)this, "expirationTimeInMillis", 0L);
        this.startTime = builder.startTime;
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, (Object)this, "startTimeInMillis", 0L);
        this.completionTime = builder.completionTime;
        this.completionTimeInMillis = builder.completionTimeInMillis;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final boolean isPartial() {
        return this.isPartial;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    @Nullable
    public final DateTime expirationTime() {
        return this.expirationTime;
    }

    public final long expirationTimeInMillis() {
        return this.expirationTimeInMillis;
    }

    @Nullable
    public final DateTime startTime() {
        return this.startTime;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final DateTime completionTime() {
        return this.completionTime;
    }

    @Nullable
    public final Long completionTimeInMillis() {
        return this.completionTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        if (this.expirationTime != null) {
            generator.writeKey("expiration_time");
            this.expirationTime.serialize(generator, mapper);
        }
        generator.writeKey("expiration_time_in_millis");
        generator.write(this.expirationTimeInMillis);
        if (this.startTime != null) {
            generator.writeKey("start_time");
            this.startTime.serialize(generator, mapper);
        }
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.completionTime != null) {
            generator.writeKey("completion_time");
            this.completionTime.serialize(generator, mapper);
        }
        if (this.completionTimeInMillis != null) {
            generator.writeKey("completion_time_in_millis");
            generator.write(this.completionTimeInMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAsyncSearchResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(AbstractBuilder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial");
        op.add(AbstractBuilder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running");
        op.add(AbstractBuilder::expirationTime, DateTime._DESERIALIZER, "expiration_time");
        op.add(AbstractBuilder::expirationTimeInMillis, JsonpDeserializer.longDeserializer(), "expiration_time_in_millis");
        op.add(AbstractBuilder::startTime, DateTime._DESERIALIZER, "start_time");
        op.add(AbstractBuilder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(AbstractBuilder::completionTime, DateTime._DESERIALIZER, "completion_time");
        op.add(AbstractBuilder::completionTimeInMillis, JsonpDeserializer.longDeserializer(), "completion_time_in_millis");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String id;
        private Boolean isPartial;
        private Boolean isRunning;
        @Nullable
        private DateTime expirationTime;
        private Long expirationTimeInMillis;
        @Nullable
        private DateTime startTime;
        private Long startTimeInMillis;
        @Nullable
        private DateTime completionTime;
        @Nullable
        private Long completionTimeInMillis;

        public final BuilderT id(@Nullable String value) {
            this.id = value;
            return (BuilderT)this.self();
        }

        public final BuilderT isPartial(boolean value) {
            this.isPartial = value;
            return (BuilderT)this.self();
        }

        public final BuilderT isRunning(boolean value) {
            this.isRunning = value;
            return (BuilderT)this.self();
        }

        public final BuilderT expirationTime(@Nullable DateTime value) {
            this.expirationTime = value;
            return (BuilderT)this.self();
        }

        public final BuilderT expirationTimeInMillis(long value) {
            this.expirationTimeInMillis = value;
            return (BuilderT)this.self();
        }

        public final BuilderT startTime(@Nullable DateTime value) {
            this.startTime = value;
            return (BuilderT)this.self();
        }

        public final BuilderT startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return (BuilderT)this.self();
        }

        public final BuilderT completionTime(@Nullable DateTime value) {
            this.completionTime = value;
            return (BuilderT)this.self();
        }

        public final BuilderT completionTimeInMillis(@Nullable Long value) {
            this.completionTimeInMillis = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

