/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ScriptBase;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch.security.RoleTemplateInlineQuery;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleTemplateInlineScript
extends ScriptBase {
    @Nullable
    private final String lang;
    private final Map<String, String> options;
    private final RoleTemplateInlineQuery source;
    public static final JsonpDeserializer<RoleTemplateInlineScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleTemplateInlineScript::setupRoleTemplateInlineScriptDeserializer);

    private RoleTemplateInlineScript(Builder builder) {
        super(builder);
        this.lang = builder.lang;
        this.options = ApiTypeHelper.unmodifiable(builder.options);
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
    }

    public static RoleTemplateInlineScript of(Function<Builder, ObjectBuilder<RoleTemplateInlineScript>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    public final Map<String, String> options() {
        return this.options;
    }

    public final RoleTemplateInlineQuery source() {
        return this.source;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lang != null) {
            generator.writeKey("lang");
            generator.write(this.lang);
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.options.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
    }

    protected static void setupRoleTemplateInlineScriptDeserializer(ObjectDeserializer<Builder> op) {
        ScriptBase.setupScriptBaseDeserializer(op);
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::options, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "options");
        op.add(Builder::source, RoleTemplateInlineQuery._DESERIALIZER, "source");
        op.shortcutProperty("source");
    }

    public static class Builder
    extends ScriptBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RoleTemplateInlineScript> {
        @Nullable
        private String lang;
        @Nullable
        private Map<String, String> options;
        private RoleTemplateInlineQuery source;

        public final Builder lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder lang(@Nullable ScriptLanguage value) {
            this.lang = value == null ? null : value.jsonValue();
            return this;
        }

        public final Builder options(Map<String, String> map) {
            this.options = Builder._mapPutAll(this.options, map);
            return this;
        }

        public final Builder options(String key, String value) {
            this.options = Builder._mapPut(this.options, key, value);
            return this;
        }

        public final Builder source(RoleTemplateInlineQuery value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<RoleTemplateInlineQuery.Builder, ObjectBuilder<RoleTemplateInlineQuery>> fn) {
            return this.source(fn.apply(new RoleTemplateInlineQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RoleTemplateInlineScript build() {
            this._checkSingleUse();
            return new RoleTemplateInlineScript(this);
        }
    }
}

