/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MatchOnlyTextProperty
implements PropertyVariant,
JsonpSerializable {
    private final Map<String, Property> fields;
    private final Map<String, String> meta;
    private final List<String> copyTo;
    public static final JsonpDeserializer<MatchOnlyTextProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatchOnlyTextProperty::setupMatchOnlyTextPropertyDeserializer);

    private MatchOnlyTextProperty(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.copyTo = ApiTypeHelper.unmodifiable(builder.copyTo);
    }

    public static MatchOnlyTextProperty of(Function<Builder, ObjectBuilder<MatchOnlyTextProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.MatchOnlyText;
    }

    public final Map<String, Property> fields() {
        return this.fields;
    }

    public final Map<String, String> meta() {
        return this.meta;
    }

    public final List<String> copyTo() {
        return this.copyTo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "match_only_text");
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Property> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.copyTo)) {
            generator.writeKey("copy_to");
            generator.writeStartArray();
            for (String string : this.copyTo) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMatchOnlyTextPropertyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "fields");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta");
        op.add(Builder::copyTo, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "copy_to");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MatchOnlyTextProperty> {
        @Nullable
        private Map<String, Property> fields;
        @Nullable
        private Map<String, String> meta;
        @Nullable
        private List<String> copyTo;

        public final Builder fields(Map<String, Property> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, Property value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.fields(key, fn.apply(new Property.Builder()).build());
        }

        public final Builder meta(Map<String, String> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, String value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder copyTo(List<String> list) {
            this.copyTo = Builder._listAddAll(this.copyTo, list);
            return this;
        }

        public final Builder copyTo(String value, String ... values) {
            this.copyTo = Builder._listAdd(this.copyTo, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MatchOnlyTextProperty build() {
            this._checkSingleUse();
            return new MatchOnlyTextProperty(this);
        }
    }
}

