/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldAndFormat;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.KnnSearchResponse;
import co.elastic.clients.elasticsearch.core.knn_search.KnnSearchQuery;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Deprecated
@JsonpDeserializable
public class KnnSearchRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final SourceConfig source;
    private final List<FieldAndFormat> docvalueFields;
    private final List<String> fields;
    private final List<Query> filter;
    private final List<String> index;
    private final KnnSearchQuery knn;
    @Nullable
    private final String routing;
    private final List<String> storedFields;
    public static final JsonpDeserializer<KnnSearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnSearchRequest::setupKnnSearchRequestDeserializer);
    public static final SimpleEndpoint<KnnSearchRequest, ?> _ENDPOINT = new SimpleEndpoint<KnnSearchRequest, KnnSearchResponse<Object>>("es/knn_search", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_knn_search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, KnnSearchResponse._DESERIALIZER);

    private KnnSearchRequest(Builder builder) {
        this.source = builder.source;
        this.docvalueFields = ApiTypeHelper.unmodifiable(builder.docvalueFields);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.knn = ApiTypeHelper.requireNonNull(builder.knn, this, "knn");
        this.routing = builder.routing;
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
    }

    public static KnnSearchRequest of(Function<Builder, ObjectBuilder<KnnSearchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    public final List<FieldAndFormat> docvalueFields() {
        return this.docvalueFields;
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final List<Query> filter() {
        return this.filter;
    }

    public final List<String> index() {
        return this.index;
    }

    public final KnnSearchQuery knn() {
        return this.knn;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    public final List<String> storedFields() {
        return this.storedFields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.docvalueFields)) {
            generator.writeKey("docvalue_fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.docvalueFields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query query : this.filter) {
                query.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("knn");
        this.knn.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.storedFields)) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String string : this.storedFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupKnnSearchRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::docvalueFields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "docvalue_fields");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter");
        op.add(Builder::knn, KnnSearchQuery._DESERIALIZER, "knn");
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields");
    }

    public static <TDocument> Endpoint<KnnSearchRequest, KnnSearchResponse<TDocument>, ErrorResponse> createKnnSearchEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(KnnSearchResponse.createKnnSearchResponseDeserializer(tDocumentDeserializer));
    }

    @Deprecated
    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KnnSearchRequest> {
        @Nullable
        private SourceConfig source;
        @Nullable
        private List<FieldAndFormat> docvalueFields;
        @Nullable
        private List<String> fields;
        @Nullable
        private List<Query> filter;
        private List<String> index;
        private KnnSearchQuery knn;
        @Nullable
        private String routing;
        @Nullable
        private List<String> storedFields;

        public final Builder source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder docvalueFields(List<FieldAndFormat> list) {
            this.docvalueFields = Builder._listAddAll(this.docvalueFields, list);
            return this;
        }

        public final Builder docvalueFields(FieldAndFormat value, FieldAndFormat ... values) {
            this.docvalueFields = Builder._listAdd(this.docvalueFields, value, values);
            return this;
        }

        public final Builder docvalueFields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.docvalueFields(fn.apply(new FieldAndFormat.Builder()).build(), new FieldAndFormat[0]);
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder filter(List<Query> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(Query value, Query ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder knn(KnnSearchQuery value) {
            this.knn = value;
            return this;
        }

        public final Builder knn(Function<KnnSearchQuery.Builder, ObjectBuilder<KnnSearchQuery>> fn) {
            return this.knn(fn.apply(new KnnSearchQuery.Builder()).build());
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnSearchRequest build() {
            this._checkSingleUse();
            return new KnnSearchRequest(this);
        }
    }
}

