/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.xpack.XpackInfoResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class XpackInfoRequest
extends RequestBase {
    @Nullable
    private final Boolean acceptEnterprise;
    private final List<String> categories;
    @Nullable
    private final Boolean human;
    public static final Endpoint<XpackInfoRequest, XpackInfoResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<XpackInfoRequest, XpackInfoResponse>("es/xpack.info", request -> "GET", request -> "/_xpack", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.categories)) {
            params.put("categories", request.categories.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.human != null) {
            params.put("human", String.valueOf(request.human));
        }
        if (request.acceptEnterprise != null) {
            params.put("accept_enterprise", String.valueOf(request.acceptEnterprise));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, XpackInfoResponse._DESERIALIZER);

    private XpackInfoRequest(Builder builder) {
        this.acceptEnterprise = builder.acceptEnterprise;
        this.categories = ApiTypeHelper.unmodifiable(builder.categories);
        this.human = builder.human;
    }

    public static XpackInfoRequest of(Function<Builder, ObjectBuilder<XpackInfoRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean acceptEnterprise() {
        return this.acceptEnterprise;
    }

    public final List<String> categories() {
        return this.categories;
    }

    @Nullable
    public final Boolean human() {
        return this.human;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<XpackInfoRequest> {
        @Nullable
        private Boolean acceptEnterprise;
        @Nullable
        private List<String> categories;
        @Nullable
        private Boolean human;

        public final Builder acceptEnterprise(@Nullable Boolean value) {
            this.acceptEnterprise = value;
            return this;
        }

        public final Builder categories(List<String> list) {
            this.categories = Builder._listAddAll(this.categories, list);
            return this;
        }

        public final Builder categories(String value, String ... values) {
            this.categories = Builder._listAdd(this.categories, value, values);
            return this;
        }

        public final Builder human(@Nullable Boolean value) {
            this.human = value;
            return this;
        }

        @Override
        public XpackInfoRequest build() {
            this._checkSingleUse();
            return new XpackInfoRequest(this);
        }
    }
}

