/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.EmailAttachment;
import co.elastic.clients.elasticsearch.watcher.EmailAttachmentVariant;
import co.elastic.clients.elasticsearch.watcher.HttpInputRequestDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HttpEmailAttachment
implements EmailAttachmentVariant,
JsonpSerializable {
    @Nullable
    private final String contentType;
    @Nullable
    private final Boolean inline;
    @Nullable
    private final HttpInputRequestDefinition request;
    public static final JsonpDeserializer<HttpEmailAttachment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpEmailAttachment::setupHttpEmailAttachmentDeserializer);

    private HttpEmailAttachment(Builder builder) {
        this.contentType = builder.contentType;
        this.inline = builder.inline;
        this.request = builder.request;
    }

    public static HttpEmailAttachment of(Function<Builder, ObjectBuilder<HttpEmailAttachment>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public EmailAttachment.Kind _emailAttachmentKind() {
        return EmailAttachment.Kind.Http;
    }

    @Nullable
    public final String contentType() {
        return this.contentType;
    }

    @Nullable
    public final Boolean inline() {
        return this.inline;
    }

    @Nullable
    public final HttpInputRequestDefinition request() {
        return this.request;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.contentType != null) {
            generator.writeKey("content_type");
            generator.write(this.contentType);
        }
        if (this.inline != null) {
            generator.writeKey("inline");
            generator.write(this.inline.booleanValue());
        }
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
    }

    protected static void setupHttpEmailAttachmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::contentType, JsonpDeserializer.stringDeserializer(), "content_type");
        op.add(Builder::inline, JsonpDeserializer.booleanDeserializer(), "inline");
        op.add(Builder::request, HttpInputRequestDefinition._DESERIALIZER, "request");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HttpEmailAttachment> {
        @Nullable
        private String contentType;
        @Nullable
        private Boolean inline;
        @Nullable
        private HttpInputRequestDefinition request;

        public final Builder contentType(@Nullable String value) {
            this.contentType = value;
            return this;
        }

        public final Builder inline(@Nullable Boolean value) {
            this.inline = value;
            return this;
        }

        public final Builder request(@Nullable HttpInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<HttpInputRequestDefinition.Builder, ObjectBuilder<HttpInputRequestDefinition>> fn) {
            return this.request(fn.apply(new HttpInputRequestDefinition.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpEmailAttachment build() {
            this._checkSingleUse();
            return new HttpEmailAttachment(this);
        }
    }
}

