/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch.snapshot.CleanupRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.CleanupRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.CloneSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.CloneSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.CreateRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.CreateRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.CreateSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.CreateSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.DeleteRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.DeleteRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.GetRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.GetRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.GetSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.GetSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.RestoreRequest;
import co.elastic.clients.elasticsearch.snapshot.RestoreResponse;
import co.elastic.clients.elasticsearch.snapshot.SnapshotStatusRequest;
import co.elastic.clients.elasticsearch.snapshot.SnapshotStatusResponse;
import co.elastic.clients.elasticsearch.snapshot.VerifyRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.VerifyRepositoryResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchSnapshotAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchSnapshotAsyncClient> {
    public ElasticsearchSnapshotAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchSnapshotAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchSnapshotAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchSnapshotAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<CleanupRepositoryResponse> cleanupRepository(CleanupRepositoryRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)CleanupRepositoryRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CleanupRepositoryResponse> cleanupRepository(Function<CleanupRepositoryRequest.Builder, ObjectBuilder<CleanupRepositoryRequest>> fn) {
        return this.cleanupRepository(fn.apply(new CleanupRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<CloneSnapshotResponse> clone(CloneSnapshotRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)CloneSnapshotRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CloneSnapshotResponse> clone(Function<CloneSnapshotRequest.Builder, ObjectBuilder<CloneSnapshotRequest>> fn) {
        return this.clone(fn.apply(new CloneSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<CreateSnapshotResponse> create(CreateSnapshotRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)CreateSnapshotRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CreateSnapshotResponse> create(Function<CreateSnapshotRequest.Builder, ObjectBuilder<CreateSnapshotRequest>> fn) {
        return this.create(fn.apply(new CreateSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)CreateRepositoryRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CreateRepositoryResponse> createRepository(Function<CreateRepositoryRequest.Builder, ObjectBuilder<CreateRepositoryRequest>> fn) {
        return this.createRepository(fn.apply(new CreateRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<DeleteSnapshotResponse> delete(DeleteSnapshotRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteSnapshotRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteSnapshotResponse> delete(Function<DeleteSnapshotRequest.Builder, ObjectBuilder<DeleteSnapshotRequest>> fn) {
        return this.delete(fn.apply(new DeleteSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteRepositoryRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteRepositoryResponse> deleteRepository(Function<DeleteRepositoryRequest.Builder, ObjectBuilder<DeleteRepositoryRequest>> fn) {
        return this.deleteRepository(fn.apply(new DeleteRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<GetSnapshotResponse> get(GetSnapshotRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetSnapshotRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetSnapshotResponse> get(Function<GetSnapshotRequest.Builder, ObjectBuilder<GetSnapshotRequest>> fn) {
        return this.get(fn.apply(new GetSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<GetRepositoryResponse> getRepository(GetRepositoryRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetRepositoryRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetRepositoryResponse> getRepository(Function<GetRepositoryRequest.Builder, ObjectBuilder<GetRepositoryRequest>> fn) {
        return this.getRepository(fn.apply(new GetRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<GetRepositoryResponse> getRepository() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetRepositoryRequest.Builder().build(), GetRepositoryRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<RestoreResponse> restore(RestoreRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)RestoreRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<RestoreResponse> restore(Function<RestoreRequest.Builder, ObjectBuilder<RestoreRequest>> fn) {
        return this.restore(fn.apply(new RestoreRequest.Builder()).build());
    }

    public CompletableFuture<SnapshotStatusResponse> status(SnapshotStatusRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)SnapshotStatusRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<SnapshotStatusResponse> status(Function<SnapshotStatusRequest.Builder, ObjectBuilder<SnapshotStatusRequest>> fn) {
        return this.status(fn.apply(new SnapshotStatusRequest.Builder()).build());
    }

    public CompletableFuture<SnapshotStatusResponse> status() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new SnapshotStatusRequest.Builder().build(), SnapshotStatusRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<VerifyRepositoryResponse> verifyRepository(VerifyRepositoryRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)VerifyRepositoryRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<VerifyRepositoryResponse> verifyRepository(Function<VerifyRepositoryRequest.Builder, ObjectBuilder<VerifyRepositoryRequest>> fn) {
        return this.verifyRepository(fn.apply(new VerifyRepositoryRequest.Builder()).build());
    }
}

