/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.SamlAuthenticateResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SamlAuthenticateRequest
extends RequestBase
implements JsonpSerializable {
    private final String content;
    private final List<String> ids;
    @Nullable
    private final String realm;
    public static final JsonpDeserializer<SamlAuthenticateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamlAuthenticateRequest::setupSamlAuthenticateRequestDeserializer);
    public static final Endpoint<SamlAuthenticateRequest, SamlAuthenticateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SamlAuthenticateRequest, SamlAuthenticateResponse>("es/security.saml_authenticate", request -> "POST", request -> "/_security/saml/authenticate", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SamlAuthenticateResponse._DESERIALIZER);

    private SamlAuthenticateRequest(Builder builder) {
        this.content = ApiTypeHelper.requireNonNull(builder.content, this, "content");
        this.ids = ApiTypeHelper.unmodifiableRequired(builder.ids, (Object)this, "ids");
        this.realm = builder.realm;
    }

    public static SamlAuthenticateRequest of(Function<Builder, ObjectBuilder<SamlAuthenticateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String content() {
        return this.content;
    }

    public final List<String> ids() {
        return this.ids;
    }

    @Nullable
    public final String realm() {
        return this.realm;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("content");
        generator.write(this.content);
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String item0 : this.ids) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.realm != null) {
            generator.writeKey("realm");
            generator.write(this.realm);
        }
    }

    protected static void setupSamlAuthenticateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::content, JsonpDeserializer.stringDeserializer(), "content");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SamlAuthenticateRequest> {
        private String content;
        private List<String> ids;
        @Nullable
        private String realm;

        public final Builder content(String value) {
            this.content = value;
            return this;
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder realm(@Nullable String value) {
            this.realm = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SamlAuthenticateRequest build() {
            this._checkSingleUse();
            return new SamlAuthenticateRequest(this);
        }
    }
}

