/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.Weights;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AggregateOutput
implements JsonpSerializable {
    @Nullable
    private final Weights logisticRegression;
    @Nullable
    private final Weights weightedSum;
    @Nullable
    private final Weights weightedMode;
    @Nullable
    private final Weights exponent;
    public static final JsonpDeserializer<AggregateOutput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AggregateOutput::setupAggregateOutputDeserializer);

    private AggregateOutput(Builder builder) {
        this.logisticRegression = builder.logisticRegression;
        this.weightedSum = builder.weightedSum;
        this.weightedMode = builder.weightedMode;
        this.exponent = builder.exponent;
    }

    public static AggregateOutput of(Function<Builder, ObjectBuilder<AggregateOutput>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Weights logisticRegression() {
        return this.logisticRegression;
    }

    @Nullable
    public final Weights weightedSum() {
        return this.weightedSum;
    }

    @Nullable
    public final Weights weightedMode() {
        return this.weightedMode;
    }

    @Nullable
    public final Weights exponent() {
        return this.exponent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.logisticRegression != null) {
            generator.writeKey("logistic_regression");
            this.logisticRegression.serialize(generator, mapper);
        }
        if (this.weightedSum != null) {
            generator.writeKey("weighted_sum");
            this.weightedSum.serialize(generator, mapper);
        }
        if (this.weightedMode != null) {
            generator.writeKey("weighted_mode");
            this.weightedMode.serialize(generator, mapper);
        }
        if (this.exponent != null) {
            generator.writeKey("exponent");
            this.exponent.serialize(generator, mapper);
        }
    }

    protected static void setupAggregateOutputDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::logisticRegression, Weights._DESERIALIZER, "logistic_regression");
        op.add(Builder::weightedSum, Weights._DESERIALIZER, "weighted_sum");
        op.add(Builder::weightedMode, Weights._DESERIALIZER, "weighted_mode");
        op.add(Builder::exponent, Weights._DESERIALIZER, "exponent");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AggregateOutput> {
        @Nullable
        private Weights logisticRegression;
        @Nullable
        private Weights weightedSum;
        @Nullable
        private Weights weightedMode;
        @Nullable
        private Weights exponent;

        public final Builder logisticRegression(@Nullable Weights value) {
            this.logisticRegression = value;
            return this;
        }

        public final Builder logisticRegression(Function<Weights.Builder, ObjectBuilder<Weights>> fn) {
            return this.logisticRegression(fn.apply(new Weights.Builder()).build());
        }

        public final Builder weightedSum(@Nullable Weights value) {
            this.weightedSum = value;
            return this;
        }

        public final Builder weightedSum(Function<Weights.Builder, ObjectBuilder<Weights>> fn) {
            return this.weightedSum(fn.apply(new Weights.Builder()).build());
        }

        public final Builder weightedMode(@Nullable Weights value) {
            this.weightedMode = value;
            return this;
        }

        public final Builder weightedMode(Function<Weights.Builder, ObjectBuilder<Weights>> fn) {
            return this.weightedMode(fn.apply(new Weights.Builder()).build());
        }

        public final Builder exponent(@Nullable Weights value) {
            this.exponent = value;
            return this;
        }

        public final Builder exponent(Function<Weights.Builder, ObjectBuilder<Weights>> fn) {
            return this.exponent(fn.apply(new Weights.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AggregateOutput build() {
            this._checkSingleUse();
            return new AggregateOutput(this);
        }
    }
}

