/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ForecastResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final String forecastId;
    public static final JsonpDeserializer<ForecastResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForecastResponse::setupForecastResponseDeserializer);

    private ForecastResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, this, "acknowledged");
        this.forecastId = ApiTypeHelper.requireNonNull(builder.forecastId, this, "forecastId");
    }

    public static ForecastResponse of(Function<Builder, ObjectBuilder<ForecastResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final String forecastId() {
        return this.forecastId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        generator.writeKey("forecast_id");
        generator.write(this.forecastId);
    }

    protected static void setupForecastResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::forecastId, JsonpDeserializer.stringDeserializer(), "forecast_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ForecastResponse> {
        private Boolean acknowledged;
        private String forecastId;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder forecastId(String value) {
            this.forecastId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForecastResponse build() {
            this._checkSingleUse();
            return new ForecastResponse(this);
        }
    }
}

