/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.license.License;
import co.elastic.clients.elasticsearch.license.PostResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PostRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean acknowledge;
    @Nullable
    private final License license;
    private final List<License> licenses;
    public static final JsonpDeserializer<PostRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostRequest::setupPostRequestDeserializer);
    public static final Endpoint<PostRequest, PostResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PostRequest, PostResponse>("es/license.post", request -> "PUT", request -> "/_license", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.acknowledge != null) {
            params.put("acknowledge", String.valueOf(request.acknowledge));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PostResponse._DESERIALIZER);

    private PostRequest(Builder builder) {
        this.acknowledge = builder.acknowledge;
        this.license = builder.license;
        this.licenses = ApiTypeHelper.unmodifiableRequired(builder.licenses, (Object)this, "licenses");
    }

    public static PostRequest of(Function<Builder, ObjectBuilder<PostRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean acknowledge() {
        return this.acknowledge;
    }

    @Nullable
    public final License license() {
        return this.license;
    }

    public final List<License> licenses() {
        return this.licenses;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.license != null) {
            generator.writeKey("license");
            this.license.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.licenses)) {
            generator.writeKey("licenses");
            generator.writeStartArray();
            for (License item0 : this.licenses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPostRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::license, License._DESERIALIZER, "license");
        op.add(Builder::licenses, JsonpDeserializer.arrayDeserializer(License._DESERIALIZER), "licenses");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PostRequest> {
        @Nullable
        private Boolean acknowledge;
        @Nullable
        private License license;
        private List<License> licenses;

        public final Builder acknowledge(@Nullable Boolean value) {
            this.acknowledge = value;
            return this;
        }

        public final Builder license(@Nullable License value) {
            this.license = value;
            return this;
        }

        public final Builder license(Function<License.Builder, ObjectBuilder<License>> fn) {
            return this.license(fn.apply(new License.Builder()).build());
        }

        public final Builder licenses(List<License> list) {
            this.licenses = Builder._listAddAll(this.licenses, list);
            return this;
        }

        public final Builder licenses(License value, License ... values) {
            this.licenses = Builder._listAdd(this.licenses, value, values);
            return this;
        }

        public final Builder licenses(Function<License.Builder, ObjectBuilder<License>> fn) {
            return this.licenses(fn.apply(new License.Builder()).build(), new License[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostRequest build() {
            this._checkSingleUse();
            return new PostRequest(this);
        }
    }
}

